/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.collab.SharableImpl;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSelectionComponent;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceFactory;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.GeoSelectionPanel;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.ui.DataSelectionWidget;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.FilePoller;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.Poller;
import ucar.unidata.util.PollingInfo;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlPersistable;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import visad.Data;
import visad.DateTime;
import visad.VisADException;

public class DataSourceImpl
extends SharableImpl
implements DataSource,
DataSourceFactory,
XmlPersistable {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DataSourceImpl.class.getName());
    public static int PARAM_SHOW_YES = 0;
    public static int PARAM_SHOW_HIDE = 1;
    public static int PARAM_SHOW_NO = 2;
    private List tmpPaths;
    private boolean dataIsEditable = false;
    private Object DATACHOICES_MUTEX = new Object();
    protected Object dataCacheKey = Misc.getUniqueId();
    private String alias = "";
    private static int nextId;
    private int dataChoiceCnt = 0;
    private boolean inError = false;
    private boolean needToShowErrorToUser = true;
    private String errorMessage = null;
    private String name = "";
    private boolean everChangedName = false;
    String description = "";
    private List relativePaths;
    protected List<DataChoice> dataChoices = null;
    private DataSourceDescriptor descriptor;
    private List timesList = null;
    private DataSelection theDataSelection;
    private Hashtable properties;
    private List dataChangeListeners = new ArrayList();
    private List pollers;
    private PollingInfo pollingInfo;
    private boolean haveInitedPolling = false;
    private JDialog propertiesDialog;
    JEditorPane detailsEditor;
    private JCheckBox reloadCbx;
    protected JCheckBox changeDataPathsCbx = new JCheckBox("Change data source", true);
    protected GeoSelectionPanel geoSelectionPanel;
    private JTextField aliasFld;
    private JTextField nameFld;
    private DataSelectionWidget dsw;
    protected boolean haveBeenUnPersisted = false;
    private boolean initAfterUnpersistenceBeenCalled = false;
    private static int outstandingGetDataCalls;
    private static Object MUTEX_OUTSTANDINGGETDATACALLS;
    private JCheckBox cacheDataToDiskCbx;
    private JTextField cacheClearDelayFld;
    private boolean cacheDataToDisk = false;
    private long cacheClearDelay = 0L;
    private String dataCachePath;
    private Object DATACACHEPATH_MUTEX = new Object();
    private List paramsToShow;
    static int cnt;
    int mycnt = cnt++;
    protected boolean okToContinue = true;
    private String userName;
    private String password;
    private boolean defaultSave = false;

    public DataSourceImpl() {
        this.haveBeenUnPersisted = true;
    }

    public DataSourceImpl(DataSourceDescriptor descriptor) {
        this(descriptor, null, null, null);
    }

    public DataSourceImpl(DataSourceDescriptor descriptor, String name, String description, Hashtable properties) {
        this.properties = properties;
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (descriptor != null && descriptor.getProperties() != null) {
            this.properties.putAll(descriptor.getProperties());
        }
        this.descriptor = descriptor;
        this.description = description;
        String v = this.getProperty("TITLE", null);
        if (v == null) {
            v = this.getProperty("name", null);
        }
        this.name = v != null ? v : name;
        this.theDataSelection = new DataSelection(true);
        this.pollingInfo = (PollingInfo)this.getProperty("prop.pollinfo");
        if (this.pollingInfo != null && this.pollingInfo.hasName()) {
            this.setName(this.pollingInfo.getName());
        }
    }

    @Override
    public void reloadData(Object object, Hashtable properties) {
        System.err.println("Reload data:" + object);
    }

    public void reloadProperties(Hashtable newProperties) {
        String v;
        this.properties = newProperties;
        if (!this.everChangedName && (v = (String)newProperties.get("TITLE")) != null) {
            this.setName(v);
            if (this.nameFld != null) {
                this.nameFld.setText(v);
            }
        }
    }

    public String convertSourceFile(String source) throws Exception {
        if (this.descriptor != null && this.descriptor.getNcmlTemplate() != null) {
            String ncml = IOUtil.readContents(this.descriptor.getNcmlTemplate(), this.getClass());
            String file = this.getDataContext().getObjectStore().getUniqueTmpFile("ncmltemplate", ".ncml");
            ncml = ncml.replace("%location%", "" + IOUtil.getURL(source, this.getClass()));
            IOUtil.writeFile(file, ncml);
            return file;
        }
        source = source.replace(":-1/", "/");
        return source;
    }

    protected boolean canDoFieldMask() {
        return false;
    }

    @Override
    public boolean canDoAllLevels() {
        return true;
    }

    public IntegratedDataViewer getIdv() {
        if (this.getDataContext() == null) {
            return null;
        }
        return this.getDataContext().getIdv();
    }

    protected void loadFieldMask() {
        if (this.getIdv() == null) {
            return;
        }
        String maskFile = this.getIdv().getProperty(this.getClass().getName() + ".maskfile", null);
        if (maskFile != null) {
            this.loadFieldMask(maskFile);
        }
        if ((maskFile = (String)this.getProperty("idv.data.maskfile")) != null) {
            this.loadFieldMask(maskFile);
        }
    }

    protected void loadFieldMask(String maskFile) {
        try {
            String xml = IOUtil.readContents(maskFile, this.getClass(), null);
            if (xml == null) {
                return;
            }
            this.applyFieldMask(XmlUtil.getRoot(xml));
        }
        catch (Exception exc) {
            throw new WrapperException(exc);
        }
    }

    protected void applyFieldMask(Element root) {
        this.paramsToShow = new ArrayList();
        XmlNodeList children = XmlUtil.getElements(root, "parameter");
        for (int j = 0; j < children.getLength(); ++j) {
            Element child = (Element)children.item(j);
            this.paramsToShow.add(child);
        }
    }

    @Override
    public boolean canAddCurrentName(DataChoice dataChoice) {
        return true;
    }

    public void writeFieldMaskFile() {
        int i;
        String jarFile = FileManager.getWriteFile(FileManager.FILTER_JAR, null);
        if (jarFile == null) {
            return;
        }
        String id = IOUtil.getFileTail(IOUtil.stripExtension(jarFile));
        String datasourceFilename = IOUtil.stripExtension(jarFile) + "datasource.xml";
        JCheckBox allCbx = new JCheckBox("Use this mask for all data sources of this type", false);
        JCheckBox installCbx = new JCheckBox("Install Plugin", false);
        JTextField labelFld = new JTextField(id);
        JTextField idFld = new JTextField(id);
        List choices = this.getDataChoices();
        ArrayList<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
        ArrayList<JCheckBox> hideCheckboxes = new ArrayList<JCheckBox>();
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Object> categories = new ArrayList<Object>();
        Hashtable<Object, ArrayList<JCheckBox>> catMap = new Hashtable<Object, ArrayList<JCheckBox>>();
        Hashtable<String, String> currentDataChoices = new Hashtable<String, String>();
        List displays = this.getIdv().getDisplayControls();
        for (i = 0; i < displays.size(); ++i) {
            List dataChoices = ((DisplayControl)displays.get(i)).getDataChoices();
            if (dataChoices == null) continue;
            ArrayList finalOnes = new ArrayList();
            for (int j = 0; j < dataChoices.size(); ++j) {
                ((DataChoice)dataChoices.get(j)).getFinalDataChoices(finalOnes);
            }
            for (int dcIdx = 0; dcIdx < finalOnes.size(); ++dcIdx) {
                DirectDataChoice ddc;
                DataChoice dc = (DataChoice)finalOnes.get(dcIdx);
                if (!(dc instanceof DirectDataChoice) || (ddc = (DirectDataChoice)dc).getDataSource() != this) continue;
                currentDataChoices.put(ddc.getName(), "");
            }
        }
        for (i = 0; i < this.dataChoices.size(); ++i) {
            ArrayList<JCheckBox> comps;
            DataChoice dataChoice = this.dataChoices.get(i);
            if (!(dataChoice instanceof DirectDataChoice)) continue;
            String label = dataChoice.getDescription();
            if (label.length() > 30) {
                label = label.substring(0, 29) + "...";
            }
            JCheckBox cbx = new JCheckBox(label, currentDataChoices.get(dataChoice.getName()) != null);
            JCheckBox hideCbx = new JCheckBox("", false);
            hideCbx.setToolTipText("If selected then the parameter is used to make derived quanitities but is not show");
            hideCheckboxes.add(hideCbx);
            cbx.setToolTipText(dataChoice.getName());
            paramNames.add(dataChoice.getName());
            checkboxes.add(cbx);
            Object dc = dataChoice.getDisplayCategory();
            if (dc == null) {
                dc = "";
            }
            if ((comps = (ArrayList<JCheckBox>)catMap.get(dc)) == null) {
                comps = new ArrayList<JCheckBox>();
                catMap.put(dc, comps);
                categories.add(dc);
            }
            comps.add(cbx);
            comps.add((JCheckBox)((Object)GuiUtils.right(hideCbx)));
            DataAlias alias = DataAlias.findAlias(dataChoice.getName());
            if (alias == null) continue;
            JCheckBox canonCbx = new JCheckBox("Include As Alias: " + alias.getName(), false);
            checkboxes.add(canonCbx);
            hideCbx = new JCheckBox("", false);
            hideCbx.setToolTipText("If selected then the parameter is used to make derived quanitities but is not shown");
            hideCheckboxes.add(hideCbx);
            paramNames.add(alias.getName());
            comps.add((JCheckBox)((Object)GuiUtils.inset((Component)canonCbx, new Insets(0, 10, 0, 0))));
            comps.add((JCheckBox)((Object)GuiUtils.right(hideCbx)));
        }
        JTabbedPane tab = new JTabbedPane();
        ArrayList catComps = new ArrayList();
        for (int i2 = 0; i2 < categories.size(); ++i2) {
            List comps = (List)catMap.get(categories.get(i2));
            JPanel innerPanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_YY, GuiUtils.WT_N);
            JScrollPane sp = new JScrollPane(GuiUtils.top(innerPanel));
            sp.setPreferredSize(new Dimension(300, 400));
            JPanel top = GuiUtils.right(GuiUtils.inset((Component)new JLabel("Hide"), new Insets(0, 0, 0, 20)));
            JPanel inner = GuiUtils.inset((Component)GuiUtils.topCenter(top, sp), 5);
            tab.addTab(categories.get(i2).toString(), inner);
        }
        JComponent contents = tab;
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel top = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("ID:"), idFld, GuiUtils.rLabel("Label:"), labelFld, GuiUtils.filler(), GuiUtils.left(allCbx), GuiUtils.filler(), GuiUtils.left(installCbx)}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        top = GuiUtils.vbox((Component)top, new JLabel("Select the fields to write"));
        top = GuiUtils.inset((Component)top, 5);
        contents = GuiUtils.topCenter(top, contents);
        if (!GuiUtils.showOkCancelDialog(null, "Data Source Field Mask File", contents = GuiUtils.inset((Component)contents, 5), null)) {
            return;
        }
        try {
            Document doc = XmlUtil.makeDocument();
            Element root = doc.createElement("mask");
            for (int i3 = 0; i3 < checkboxes.size(); ++i3) {
                JCheckBox cbx = (JCheckBox)checkboxes.get(i3);
                JCheckBox hideCbx = (JCheckBox)hideCheckboxes.get(i3);
                if (!cbx.isSelected() && !hideCbx.isSelected()) continue;
                Element child = doc.createElement("parameter");
                child.setAttribute("name", paramNames.get(i3).toString());
                if (hideCbx.isSelected()) {
                    child.setAttribute("hide", "true");
                }
                root.appendChild(child);
            }
            this.writeFieldMaskFile(doc, root);
            ArrayList<TwoFacedObject> files = new ArrayList<TwoFacedObject>();
            files.add(new TwoFacedObject((Object)(id + ".xml"), XmlUtil.toString(root).getBytes()));
            Document dsdoc = XmlUtil.makeDocument();
            Element dsroot = doc.createElement("datasources");
            Element dsnode = doc.createElement("datasource");
            Element propnode = doc.createElement("property");
            dsnode.setAttribute("id", idFld.getText());
            dsnode.setAttribute("fileselection", "true");
            dsnode.setAttribute("factory", this.getClass().getName());
            dsnode.setAttribute("label", labelFld.getText());
            propnode.setAttribute("name", "idv.data.maskfile");
            propnode.setAttribute("value", "/" + id + ".xml");
            dsroot.appendChild(dsnode);
            dsnode.appendChild(propnode);
            files.add(new TwoFacedObject((Object)(id + "datasource.xml"), XmlUtil.toString(dsroot).getBytes()));
            if (allCbx.isSelected()) {
                String props = this.getClass().getName() + ".maskfile = /" + id + ".xml";
                files.add(new TwoFacedObject((Object)(id + ".properties"), props.getBytes()));
            }
            IOUtil.writeJarFile(jarFile, files);
            if (installCbx.isSelected()) {
                this.getIdv().getPluginManager().installPluginFromFile(jarFile);
            }
        }
        catch (Exception exc) {
            this.logException("Writing field mask file", exc);
        }
    }

    protected void writeFieldMaskFile(Document doc, Element root) {
    }

    public int canShowParameter(String name) {
        if (this.paramsToShow == null || this.paramsToShow.size() == 0) {
            return PARAM_SHOW_YES;
        }
        DataAlias alias = DataAlias.findAlias(name);
        for (int i = 0; i < this.paramsToShow.size(); ++i) {
            Element node = (Element)this.paramsToShow.get(i);
            String param = XmlUtil.getAttribute(node, "name");
            boolean match = StringUtil.stringMatch(name, param);
            if (alias != null && !match) {
                match = StringUtil.stringMatch(alias.getName(), param);
            }
            if (!match) continue;
            if (XmlUtil.getAttribute((Node)node, "hide", false)) {
                return PARAM_SHOW_HIDE;
            }
            return PARAM_SHOW_YES;
        }
        return PARAM_SHOW_NO;
    }

    @Override
    public void setObjectProperties(Hashtable properties) {
        if (properties == null) {
            return;
        }
        boolean didone = false;
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)properties.get(key);
            this.setObjectProperty(key, value);
            didone = true;
        }
        if (didone) {
            this.getDataContext().dataSourceChanged(this);
        }
    }

    public void setObjectProperty(String name, String value) {
        try {
            Util.propertySet(this, name, value, false);
        }
        catch (Exception exc) {
            this.logException("setProperty:" + name + " value= " + value, exc);
        }
    }

    @Override
    public List getCompositeDataChoices(CompositeDataChoice compositeDataChoice, List dataChoices) {
        return dataChoices;
    }

    protected void initAfter() {
        if (this.getPollingInfo().getIsActive()) {
            this.startPolling();
        }
        this.loadFieldMask();
    }

    @Override
    public void initAfterUnpersistence() {
        this.initAfterUnpersistenceBeenCalled = true;
        this.initAfter();
    }

    @Override
    public void initAfterCreation() {
        this.initAfter();
    }

    @Override
    public void setNewFiles(List files) {
    }

    @Override
    public Element createElement(XmlEncoder encoder) {
        return encoder.createElementForObject(this, this.getClass());
    }

    @Override
    public boolean initFromXml(XmlEncoder encoder, Element element) {
        return true;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable p) {
        this.properties = p;
    }

    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public Object getProperty(String name) {
        Object value = null;
        if (this.properties != null) {
            value = this.properties.get(name);
        }
        if (value != null || this.descriptor != null) {
            // empty if block
        }
        return value;
    }

    public void setProperty(String prop, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(prop, value);
    }

    public String getProperty(String name, String dflt) {
        Object o = this.getProperty(name);
        if (o == null) {
            return dflt;
        }
        return o.toString();
    }

    public long getProperty(String name, long dflt) {
        Object o = this.getProperty(name);
        if (o == null) {
            return dflt;
        }
        return new Long(o.toString());
    }

    public int getProperty(String name, int dflt) {
        Object o = this.getProperty(name);
        if (o == null) {
            return dflt;
        }
        return new Integer(o.toString());
    }

    public double getProperty(String name, double dflt) {
        Object o = this.getProperty(name);
        if (o == null) {
            return dflt;
        }
        return Misc.parseDouble(o.toString());
    }

    public Object getProperty(String name, Object dflt) {
        Object o = this.getProperty(name);
        if (o == null) {
            return dflt;
        }
        return o;
    }

    public boolean getProperty(String name, boolean dflt) {
        Object o = this.getProperty(name);
        if (o == null) {
            return dflt;
        }
        return new Boolean(o.toString());
    }

    public void setProperty(String prop, boolean value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(prop, new Boolean(value));
    }

    @Override
    public boolean getNeedToShowErrorToUser() {
        return this.needToShowErrorToUser;
    }

    @Override
    public boolean getInError() {
        return this.inError;
    }

    public void setInError(boolean e, String msg) {
        this.setInError(e, true, msg);
    }

    public void setInError(boolean inError, boolean needToShowErrorToUser, String msg) {
        this.needToShowErrorToUser = needToShowErrorToUser;
        this.inError = inError;
        this.errorMessage = msg;
    }

    @Override
    public void setInError(boolean e) {
        this.inError = e;
    }

    @Override
    public String getErrorMessage() {
        if (this.errorMessage == null) {
            return "Data load failed for " + this.getClass().getName();
        }
        return this.errorMessage;
    }

    @Override
    public void clearCachedData() {
    }

    protected void flushCache() {
        CacheManager.remove(this.dataCacheKey);
    }

    public void putCache(Object key, Object value) {
        this.putCache(key, value, false);
    }

    public void putCache(Object key, Object value, boolean force) {
        CacheManager.put(this.dataCacheKey, key, value, force);
    }

    public Object getCache(Object key) {
        return this.getCache(key, false);
    }

    public Object getCache(Object key, boolean force) {
        return CacheManager.get(this.dataCacheKey, key, force);
    }

    public void removeCache(Object key) {
        CacheManager.remove(this.dataCacheKey, key);
    }

    protected boolean shouldCache(DataChoice dataChoice, Data data) {
        return this.shouldCache(data);
    }

    protected boolean shouldCache(Data data) {
        return true;
    }

    @Override
    public void doRemove() {
        if (this.propertiesDialog != null) {
            this.propertiesDialog.dispose();
        }
        try {
            this.flushCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeSharable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stopPolling();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearFileCache();
        this.dataChangeListeners = null;
        this.dataChoices = null;
    }

    protected File loadLatestFile(File file) {
        if (file.isDirectory()) {
            File mostRecent = IOUtil.getMostRecentFile(file, this.descriptor.getFilePatternFilter());
            if (mostRecent == null) {
                throw new IllegalArgumentException("No file in directory:" + file);
            }
            return mostRecent;
        }
        return file;
    }

    protected File doDirectory(File file) {
        return this.loadLatestFile(file);
    }

    private void startPolling() {
        Trace.msg("DataSourceImpl.startPolling");
        if (this.pollers != null && this.pollers.size() > 0) {
            Trace.msg("DataSourceImpl.startPolling - Already polling");
            return;
        }
        this.getPollingInfo().setIsActive(true);
        Poller poller = null;
        if (this.pollingInfo.getForFiles()) {
            poller = new FilePoller(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List files = (List)e.getSource();
                    DataSourceImpl.this.newFilesFromPolling(files);
                }
            }, this.pollingInfo);
        } else {
            poller = new Poller(this.pollingInfo.getInterval()){

                @Override
                protected void doPoll() {
                    Trace.msg("DataSourceImpl: calling reload");
                    DataSourceImpl.this.reloadData();
                }
            };
            poller.init();
        }
        if (this.pollers == null) {
            this.pollers = new ArrayList();
        }
        this.pollers.add(poller);
    }

    private void stopPolling() {
        this.getPollingInfo().setIsActive(false);
        if (this.pollers != null) {
            for (int i = 0; i < this.pollers.size(); ++i) {
                ((Poller)this.pollers.get(i)).stopRunning();
            }
            this.pollers = null;
        }
    }

    public void newFilesFromPolling(List files) {
        if (files.size() > 0) {
            this.newFileFromPolling((File)files.get(0));
        }
    }

    public void newFileFromPolling(File f) {
    }

    public String toString() {
        return this.name;
    }

    public String toStringTruncated() {
        String s = this.toString();
        if (s.length() > 30) {
            s = s.substring(0, 29) + "...";
        }
        return s;
    }

    public String getid() {
        return this.getClass().getName() + ": " + this.toString() + " #" + this.mycnt + " ";
    }

    public void setDescriptor(DataSourceDescriptor d) {
        this.descriptor = d;
    }

    public DataSourceDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected List getDataChangeListeners() {
        return this.dataChangeListeners;
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        if (this.dataChangeListeners == null) {
            return;
        }
        if (!this.dataChangeListeners.contains(listener)) {
            this.dataChangeListeners.add(listener);
        }
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        if (this.dataChangeListeners != null) {
            this.dataChangeListeners.remove(listener);
        }
    }

    @Override
    public void reloadData() {
        final String tmp = this.dataCachePath;
        this.dataCachePath = null;
        this.timesList = null;
        this.flushCache();
        this.notifyDataChange();
        this.getDataContext().dataSourceChanged(this);
        if (tmp != null) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    IOUtil.deleteDirectory(new File(tmp));
                }
            });
        }
    }

    protected void clearFileCache() {
        final String tmp = this.dataCachePath;
        if (tmp != null) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    IOUtil.deleteDirectory(new File(tmp));
                }
            });
        }
    }

    @Override
    public void notifyDataChange() {
        if (this.dataChangeListeners == null) {
            return;
        }
        for (int i = 0; i < this.dataChangeListeners.size(); ++i) {
            ((DataChangeListener)this.dataChangeListeners.get(i)).dataChanged();
        }
    }

    public DataContext getDataContext() {
        return this.descriptor != null ? this.descriptor.getDataContext() : null;
    }

    @Override
    public DataSource getDataSource() {
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DataSourceImpl that = (DataSourceImpl)o;
        return Misc.equals(this.name, that.name) && Misc.equals(this.properties, that.properties);
    }

    @Override
    public boolean identifiedByName(String name) {
        if (name.length() == 0) {
            return true;
        }
        if (name.startsWith("class:") && StringUtil.stringMatch(this.getClass().getName(), name.substring(6), true, true)) {
            return true;
        }
        return StringUtil.stringMatch(this.getName(), name, true, true);
    }

    @Override
    public boolean identifiedBy(Object definingObject) {
        if (definingObject instanceof String && this.alias != null && this.alias.length() > 0 && this.alias.equals(definingObject.toString())) {
            return true;
        }
        return Misc.equals(definingObject, this.getUniqueId());
    }

    @Override
    public final String getTypeName() {
        return this.descriptor != null ? this.descriptor.getId() : null;
    }

    @Override
    public void createAutoDisplay(String displayType, DataContext dataContext) {
        block1: {
            List choices;
            int cIdx;
            if (displayType == null || (cIdx = 0) >= (choices = this.getDataChoices()).size()) break block1;
            DataChoice dataChoice = (DataChoice)choices.get(cIdx);
            DataSelection driverSelection = null;
            boolean useTimeDriver = this.getProperty("Chooser_Do_Time_Matching", false);
            if (useTimeDriver) {
                driverSelection = new DataSelection();
                driverSelection.getProperties().put("Use_Display_Driver_Times", true);
            }
            this.getIdv().doMakeControl(dataChoice, this.getIdv().getControlDescriptor(displayType), (String)null, driverSelection);
        }
    }

    public void initDataChoice(DataChoice dataChoice) {
        Hashtable displayProperties = (Hashtable)this.getProperty("displayproperties");
        if (displayProperties != null) {
            dataChoice.setProperties(displayProperties);
        }
        if (dataChoice instanceof CompositeDataChoice) {
            List children = ((CompositeDataChoice)dataChoice).getDataChoices();
            for (int i = 0; i < children.size(); ++i) {
                this.initDataChoice((DataChoice)children.get(i));
            }
        }
    }

    @Override
    public DataChoice findDataChoice(Object id) {
        List choices = this.findDataChoices(id);
        if (choices != null && choices.size() > 0) {
            return (DataChoice)choices.get(0);
        }
        return null;
    }

    @Override
    public List findDataChoices(Object id) {
        ArrayList<DataChoice> result = new ArrayList<DataChoice>();
        if (id == null) {
            id = "#0";
        }
        String asString = id.toString();
        List choices = this.getDataChoices();
        if (asString.startsWith("#")) {
            try {
                int index = new Integer(asString.substring(1));
                if (index < choices.size() && index >= 0) {
                    return Misc.newList(choices.get(index));
                }
            }
            catch (NumberFormatException index) {
                // empty catch block
            }
        }
        String sid = null;
        boolean isRegexp = false;
        if (id instanceof String) {
            sid = id.toString();
            if (sid.startsWith("pattern:")) {
                isRegexp = true;
                sid = sid.substring(8);
            } else {
                isRegexp = StringUtil.containsRegExp(sid);
            }
        }
        for (DataChoice choice : choices) {
            if (choice.getId().equals(id)) {
                result.add(choice.cloneMe());
                continue;
            }
            if (choice.toString().equals(asString)) {
                result.add(choice.cloneMe());
                continue;
            }
            if (choice.getName().equals(asString)) {
                result.add(choice.cloneMe());
                continue;
            }
            String canonical = DataAlias.aliasToCanonical(choice.getName().toString());
            if (canonical != null && canonical.toLowerCase().equals(asString.toLowerCase())) {
                result.add(choice.cloneMe());
                continue;
            }
            if (sid == null || !isRegexp) continue;
            if (StringUtil.stringMatch(choice.getDescription(), sid, true, false)) {
                result.add(choice.cloneMe());
                continue;
            }
            if (!StringUtil.stringMatch(choice.getName(), sid, true, false)) continue;
            result.add(choice.cloneMe());
        }
        return result;
    }

    protected void checkForInitAfterUnPersistence() {
        if (this.haveBeenUnPersisted && !this.initAfterUnpersistenceBeenCalled) {
            this.initAfterUnpersistence();
        }
    }

    protected void makeDerivedDataChoices(List dataChoices) {
        if (this.getIdv() == null) {
            return;
        }
        List derivedList = this.getIdv().getDerivedDataChoices(this, dataChoices);
        if (derivedList != null) {
            dataChoices.addAll(derivedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getDataChoices() {
        this.checkForInitAfterUnPersistence();
        Object object = this.DATACHOICES_MUTEX;
        synchronized (object) {
            if (this.dataChoices == null) {
                this.dataChoices = new ArrayList<DataChoice>();
                this.doMakeDataChoices();
                this.makeDerivedDataChoices(this.dataChoices);
                for (int i = 0; i < this.dataChoices.size(); ++i) {
                    this.initDataChoice(this.dataChoices.get(i));
                }
                List selectedTimes = this.getDataSelection().getTimes();
                if (DataSourceImpl.holdsDateTimes(selectedTimes)) {
                    this.getDataSelection().setTimes(Misc.getIndexList(selectedTimes, this.getAllDateTimes()));
                }
            }
            return this.dataChoices;
        }
    }

    @Override
    public List getAllLevels(DataChoice dataChoice) {
        return this.getAllLevels(dataChoice, null);
    }

    @Override
    public List getAllLevels(DataChoice dataChoice, DataSelection dataSelection) {
        return null;
    }

    public void clearTimes() {
        this.timesList = null;
    }

    @Override
    public List getAllDateTimes() {
        if (this.timesList == null) {
            this.timesList = this.doMakeDateTimes();
        }
        return this.timesList;
    }

    @Override
    public List getSelectedDateTimes() {
        return this.getDateTimeSelection();
    }

    @Override
    public List getSelectedDateTimes(DataChoice dataChoice) {
        return this.getSelectedDateTimes();
    }

    @Override
    public List getAllDateTimes(DataChoice dataChoice) {
        return this.getAllDateTimes();
    }

    @Override
    public DataSelection getDataSelection() {
        if (this.theDataSelection == null) {
            this.theDataSelection = new DataSelection();
        }
        return this.theDataSelection;
    }

    public void setDataSelection(DataSelection s) {
        this.theDataSelection = s;
    }

    public static boolean holdsDateTimes(List selectedTimes) {
        return selectedTimes != null && selectedTimes.size() > 0 && selectedTimes.get(0) instanceof DateTime;
    }

    public static boolean holdsIndices(List selectedTimes) {
        return selectedTimes != null && selectedTimes.size() > 0 && selectedTimes.get(0) instanceof Integer;
    }

    public static List getDateTimes(List selected, List allTimes) {
        if (DataSourceImpl.holdsIndices(selected)) {
            return Misc.getValuesFromIndices(selected, allTimes);
        }
        return selected;
    }

    public List getAbsoluteDateTimes(List selected) {
        return DataSourceImpl.getDateTimes(selected, this.getAllDateTimes());
    }

    @Override
    public void setDateTimeSelection(List selectedTimes) {
        if (DataSourceImpl.holdsDateTimes(selectedTimes) && this.timesList != null) {
            selectedTimes = Misc.getIndexList(selectedTimes, this.getAllDateTimes());
        }
        this.getDataSelection().setTimes(selectedTimes);
    }

    @Override
    public List getDateTimeSelection() {
        return this.getDataSelection().getTimes();
    }

    public List<DateTime> selectTimesFromList(DataSelection dataSelection, List sourceTimes, List<DateTime> selectionTimes) throws Exception {
        return DataUtil.selectTimesFromList(sourceTimes, selectionTimes);
    }

    protected List getTimesFromDataSelection(DataSelection givenDataSelection, DataChoice dataChoice) {
        List times = null;
        List allTimesFromDataChoice = dataChoice.getAllDateTimes();
        if (givenDataSelection != null) {
            List<DateTime> timeDriverTimes = givenDataSelection.getTimeDriverTimes();
            Object ud = givenDataSelection.getProperty("Use_Display_Driver_Times");
            boolean useTDT = false;
            if (ud != null) {
                useTDT = (Boolean)ud;
            }
            if (useTDT && timeDriverTimes == null) {
                ViewManager vm = null;
                String vmName = givenDataSelection.getProperty("Default_View", null);
                if (vmName != null) {
                    vm = this.getIdv().getViewManager(new ViewDescriptor(vmName), false, null);
                }
                if (vm == null) {
                    vm = this.getIdv().getViewManager();
                }
                List<DateTime> tdt = null;
                try {
                    tdt = vm.getTimeDriverTimes();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tdt != null) {
                    timeDriverTimes = tdt;
                }
            }
            if (timeDriverTimes != null && useTDT) {
                try {
                    log_.debug("time driver times:" + timeDriverTimes);
                    List<DateTime> dataSourceTimes = this.getAllTimesForTimeDriver(dataChoice, givenDataSelection, timeDriverTimes);
                    List<DateTime> selectedTimes = this.selectTimesFromList(givenDataSelection, dataSourceTimes, timeDriverTimes);
                    if (selectedTimes != null) {
                        return selectedTimes;
                    }
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            }
        }
        if (givenDataSelection != null && givenDataSelection.hasTimes()) {
            times = givenDataSelection.getTimes();
            boolean useSubset = false;
            Object sd = dataChoice.getProperty("Use DataChoice time subset");
            if (sd != null) {
                useSubset = Boolean.parseBoolean(sd.toString());
            }
            if (!useSubset) {
                times = DataSourceImpl.getDateTimes(times, this.getAllDateTimes());
            }
            if (times == null || times.size() == 0 || times.size() == allTimesFromDataChoice.size()) {
                times = allTimesFromDataChoice;
            }
            times = DataSourceImpl.getDateTimes(times, allTimesFromDataChoice);
        } else {
            times = dataChoice.getSelectedDateTimes();
        }
        if (times == null) {
            times = allTimesFromDataChoice;
        }
        return DataSourceImpl.getDateTimes(times, allTimesFromDataChoice);
    }

    protected List<DateTime> getAllTimesForTimeDriver(DataChoice dataChoice, DataSelection selection, List<DateTime> timeDriverTimes) {
        return dataChoice.getAllDateTimes();
    }

    @Override
    public Data getData(DataChoice dataChoice, DataCategory dataCategory, Hashtable requestProperties) throws VisADException, RemoteException {
        return this.getData(dataChoice, dataCategory, DataSelection.NULL, requestProperties);
    }

    protected void showWaitDialog(int count) {
        this.okToContinue = true;
    }

    protected void tick() {
    }

    public static int getOutstandingGetDataCalls() {
        return outstandingGetDataCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrOutstandingGetDataCalls() {
        Object object = MUTEX_OUTSTANDINGGETDATACALLS;
        synchronized (object) {
            ++outstandingGetDataCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrOutstandingGetDataCalls() {
        Object object = MUTEX_OUTSTANDINGGETDATACALLS;
        synchronized (object) {
            --outstandingGetDataCalls;
        }
    }

    protected Object createCacheKey(DataChoice dataChoice, DataSelection dataSelection, Hashtable requestProperties) {
        return Misc.newList(dataChoice, dataSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Data getData(DataChoice dataChoice, DataCategory category, DataSelection incomingDataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Data cachedData;
        List cacheKey;
        if (this.getInError()) {
            return null;
        }
        this.initPolling();
        this.getDataChoices();
        this.getAllDateTimes();
        log_.debug("data source data selection:" + this.getDataSelection());
        log_.debug("incoming data selection:" + incomingDataSelection);
        DataSelection selection = DataSelection.merge(incomingDataSelection, this.getDataSelection());
        DataSelection lselection = selection.cloneMe();
        boolean isProgressiveResolution = selection.getProperty("Use_Progressive_Resolution", false);
        Object baseCacheKey = this.createCacheKey(dataChoice, lselection, requestProperties);
        List list = cacheKey = baseCacheKey != null ? Misc.newList(baseCacheKey) : null;
        if (requestProperties != null) {
            Hashtable newProperties = (Hashtable)requestProperties.clone();
            newProperties.remove("prop.requester");
            if (cacheKey != null && newProperties.size() > 0) {
                cacheKey.add(newProperties.toString());
            }
        }
        Data data = cachedData = cacheKey != null ? (Data)this.getCache(cacheKey) : null;
        if (cachedData == null) {
            DataSourceImpl.incrOutstandingGetDataCalls();
            try {
                LogUtil.message("Data: " + this.toStringTruncated() + ": " + dataChoice);
                cachedData = this.getDataInner(dataChoice, category, selection, requestProperties);
                LogUtil.message("");
            }
            finally {
                DataSourceImpl.decrOutstandingGetDataCalls();
            }
            if (cacheKey != null && cachedData != null && this.shouldCache(dataChoice, cachedData)) {
                this.putCache(cacheKey, cachedData);
            }
        }
        return cachedData;
    }

    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection) throws VisADException, RemoteException {
        return null;
    }

    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        return this.getDataInner(dataChoice, category, dataSelection);
    }

    public int getNextId() {
        return nextId++;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setTemplateName(String n) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String n) {
        this.description = n;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPartialDescription() {
        return this.getDescription();
    }

    @Override
    public String getFullDescription() {
        return "<b>Name: </b>" + this.getName() + "<br>" + "<b>Description:</b>" + this.getDescription();
    }

    protected void addDataChoice(DataChoice choice) {
        int canShow;
        if (this.dataChoices == null) {
            this.dataChoices = new ArrayList<DataChoice>();
        }
        if ((canShow = this.canShowParameter(choice.getName())) == PARAM_SHOW_NO) {
            return;
        }
        if (canShow == PARAM_SHOW_HIDE) {
            choice.setProperty("forUser", false);
        }
        this.dataChoices.add(choice);
    }

    @Override
    public void expandIfNeeded(CompositeDataChoice cdc) {
    }

    protected void removeDataChoice(DataChoice choice) {
        if (this.dataChoices != null) {
            this.dataChoices.remove(choice);
        }
    }

    public void replaceDataChoice(DataChoice oldDataChoice, DataChoice newDataChoice) {
        int idx = this.dataChoices.indexOf(oldDataChoice);
        if (idx >= 0) {
            this.dataChoices.set(idx, newDataChoice);
        } else {
            this.addDataChoice(newDataChoice);
        }
    }

    protected void doMakeDataChoices() {
    }

    protected List doMakeDateTimes() {
        return new ArrayList();
    }

    public void logException(String msg, Exception exc) {
        LogUtil.printException(log_, msg, exc);
    }

    public void logException(String msg, Exception exc, byte[] fileBytes) {
        LogUtil.printException(log_, msg, (Throwable)exc, fileBytes);
    }

    @Override
    public void setAlias(String value) {
        this.alias = value;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public List getActions() {
        ArrayList l = new ArrayList();
        this.addActions(l);
        return l;
    }

    @Override
    public boolean showPropertiesDialog() {
        return this.showPropertiesDialog(null);
    }

    public boolean showPropertiesDialog(String initTabName) {
        return this.showPropertiesDialog(initTabName, false);
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return false;
    }

    public boolean canChangeData() {
        return true;
    }

    protected List saveDataToLocalDisk(String filePrefix, Object loadId, boolean changeLinks) throws Exception {
        return null;
    }

    public List saveDataToLocalDisk() {
        return this.saveDataToLocalDisk(true, null);
    }

    @Override
    public List saveDataToLocalDisk(boolean changeLinks, String uniqueFilePath) {
        String prefix;
        if (!this.canSaveDataToLocalDisk()) {
            return null;
        }
        if (uniqueFilePath == null) {
            prefix = this.getLocalDirectory(this.getName() + " Data Directory", this.getDataPrefix());
            changeLinks = this.changeDataPathsCbx.isSelected();
        } else {
            prefix = uniqueFilePath + "_" + this.getDataPrefix();
        }
        if (prefix == null) {
            return null;
        }
        Object loadId = this.beginWritingDataToLocalDisk("Copying data");
        try {
            List files = this.saveDataToLocalDisk(prefix, loadId, changeLinks);
            this.endWritingDataToLocalDisk(loadId);
            return files;
        }
        catch (Exception ioe) {
            this.endWritingDataToLocalDisk(loadId);
            this.logException("Saving data to local disk", ioe);
            return null;
        }
    }

    protected String getSaveDataFileLabel() {
        return "Copying data from server";
    }

    protected Object beginWritingDataToLocalDisk(String msg) {
        Object loadId = JobManager.getManager().startLoad(msg, true, false);
        return loadId;
    }

    protected void endWritingDataToLocalDisk(Object loadId) {
        JobManager.getManager().stopLoad(loadId);
    }

    protected String getDataPrefix() {
        return StringUtil.replace(IOUtil.cleanFileName(IOUtil.stripExtension(IOUtil.getFileTail(this.getName()))), " ", "");
    }

    protected String getLocalDirectory(String label, String prefix) {
        this.changeDataPathsCbx.setToolTipText("Should this data source also be changed");
        JTextField nameFld = new JTextField(prefix, 10);
        File dir = FileManager.getDirectory(null, label, GuiUtils.top(GuiUtils.inset((Component)GuiUtils.vbox(this.changeDataPathsCbx, GuiUtils.label("Prefix: ", nameFld)), 5)));
        if (dir == null) {
            return null;
        }
        return IOUtil.joinDir(dir, nameFld.getText().trim());
    }

    public boolean showPropertiesDialog(String initTabName, boolean modal) {
        if (modal || this.propertiesDialog == null) {
            JTabbedPane propertiesTab = new JTabbedPane();
            this.addPropertiesTabs(propertiesTab);
            if (initTabName != null) {
                for (int i = 0; i < propertiesTab.getTabCount(); ++i) {
                    if (!initTabName.equals(propertiesTab.getTitleAt(i))) continue;
                    propertiesTab.setSelectedIndex(i);
                    break;
                }
            }
            this.propertiesDialog = GuiUtils.createDialog(null, this.toString() + " Properties", modal);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String cmd = ae.getActionCommand();
                    Misc.run(DataSourceImpl.this, "handlePropertiesAction", cmd);
                }
            };
            JPanel buttons = GuiUtils.makeApplyOkCancelButtons(listener);
            if (this.reloadCbx == null) {
                this.reloadCbx = new JCheckBox("Reload Displays", false);
            }
            buttons = GuiUtils.wrap(GuiUtils.hbox((Component)buttons, this.reloadCbx));
            JPanel contents = GuiUtils.inset((Component)GuiUtils.centerBottom(propertiesTab, buttons), 5);
            this.propertiesDialog.getContentPane().add(contents);
            this.propertiesDialog.pack();
        }
        this.updateDetailsText();
        this.propertiesDialog.setVisible(true);
        return true;
    }

    protected void propertiesChanged() {
        this.getDataContext().dataSourceChanged(this);
        this.updateDetailsText();
    }

    public void handlePropertiesAction(String cmd) {
        if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
            if (this.applyProperties()) {
                this.propertiesChanged();
                if (this.reloadCbx != null && this.reloadCbx.isSelected()) {
                    Misc.run(this, "reloadData");
                }
            } else {
                return;
            }
        }
        if ((cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) && this.propertiesDialog != null) {
            this.propertiesDialog.setVisible(false);
        }
    }

    protected JComponent getPropertiesHeader(String label) {
        return GuiUtils.makeHeader(label);
    }

    public void getPropertiesComponents(List comps) {
        this.nameFld = new JTextField(this.name, 20);
        comps.add(GuiUtils.rLabel("Name: "));
        comps.add(this.nameFld);
        this.aliasFld = new JTextField("", 20);
        if (this.alias != null) {
            this.aliasFld.setText(this.alias);
        }
        if (this.canPoll()) {
            this.getPollingInfo();
            comps.add(GuiUtils.filler());
            comps.add(this.getPropertiesHeader("Polling"));
            if (this.pollingInfo.getForFiles()) {
                if (this.pollingInfo.isADirectory()) {
                    this.pollingInfo.getPropertyComponents(comps, false, true);
                } else {
                    comps.add(GuiUtils.filler());
                    comps.add(GuiUtils.left(this.pollingInfo.getActiveWidget()));
                    comps.add(GuiUtils.rLabel("Check Every: "));
                    comps.add(GuiUtils.left(GuiUtils.hbox(this.pollingInfo.getIntervalWidget(), GuiUtils.lLabel(" minutes"))));
                }
            } else {
                comps.add(GuiUtils.rLabel("Automatically Reload: "));
                comps.add(GuiUtils.left(this.pollingInfo.getActiveWidget()));
                comps.add(GuiUtils.rLabel("Check Every: "));
                comps.add(GuiUtils.left(GuiUtils.hbox(this.pollingInfo.getIntervalWidget(), GuiUtils.lLabel(" minutes"))));
            }
        }
    }

    public boolean canCacheDataToDisk() {
        return false;
    }

    @Override
    public boolean canDoGeoSelection() {
        return false;
    }

    protected boolean canDoGeoSelectionStride() {
        return true;
    }

    @Override
    public List<DataSelectionComponent> getDataSelectionComponents(DataChoice dataChoice) {
        ArrayList<DataSelectionComponent> dataSelectionComponents = new ArrayList<DataSelectionComponent>();
        this.initDataSelectionComponents(dataSelectionComponents, dataChoice);
        return dataSelectionComponents;
    }

    protected void initDataSelectionComponents(List<DataSelectionComponent> components, DataChoice dataChoice) {
    }

    protected JComponent getExtraTimesComponent() {
        return null;
    }

    public void addPropertiesTabs(JTabbedPane tabbedPane) {
        List times;
        ArrayList comps = new ArrayList();
        this.getPropertiesComponents(comps);
        if (comps.size() > 0) {
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            JPanel propertiesPanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            tabbedPane.add("Properties", GuiUtils.top(propertiesPanel));
        }
        if ((times = this.getAllDateTimes()) != null && times.size() > 0) {
            this.dsw = this.getIdv().getUseTimeDriver() ? new DataSelectionWidget(this.getIdv(), true, false) : new DataSelectionWidget(this.getIdv());
            this.dsw.setTimes(this.getAllDateTimes(), this.getDateTimeSelection());
            this.dsw.setUseAllTimes(this.getDateTimeSelection() == null);
            JComponent extraTimesComp = this.getExtraTimesComponent();
            JComponent timesComp = this.dsw.getTimesList("Use All");
            if (extraTimesComp != null) {
                tabbedPane.add("Times", GuiUtils.centerBottom(timesComp, extraTimesComp));
            } else {
                tabbedPane.add("Times", timesComp);
            }
        }
        if (this.canDoGeoSelection()) {
            tabbedPane.add("Spatial Subset", this.doMakeGeoSubsetPropertiesComponent());
        }
        this.addReloadTab(tabbedPane);
        this.detailsEditor = new JEditorPane();
        int height = 300;
        int width = 400;
        this.detailsEditor.setMinimumSize(new Dimension(width, height));
        this.detailsEditor.setPreferredSize(new Dimension(width, height));
        this.detailsEditor.setEditable(false);
        this.detailsEditor.setContentType("text/html");
        this.updateDetailsText();
        JScrollPane scroller = GuiUtils.makeScrollPane(this.detailsEditor, width, height);
        scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        scroller.setPreferredSize(new Dimension(width, height));
        scroller.setMinimumSize(new Dimension(width, height));
        tabbedPane.add("Details", GuiUtils.inset((Component)scroller, 5));
    }

    protected void addReloadTab(JTabbedPane tabbedPane) {
        try {
            String chooserClassName = (String)this.getProperty("prop.chooserclassname");
            chooserClassName = null;
            if (chooserClassName != null) {
                IdvChooser chooser = null;
                Class theClass = Misc.findClass(chooserClassName);
                Class[] paramTypes = new Class[]{IdvChooserManager.class, Element.class};
                Object[] args = new Object[]{this.getIdv().getIdvChooserManager(), null};
                Constructor ctor = Misc.findConstructor(theClass, paramTypes);
                if (ctor != null) {
                    chooser = (IdvChooser)ctor.newInstance(args);
                    chooser.setDataSource(this);
                    tabbedPane.add("Reload Data", chooser.getContents());
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected JComponent doMakeGeoSubsetPropertiesComponent() {
        this.geoSelectionPanel = this.doMakeGeoSelectionPanel();
        return this.geoSelectionPanel;
    }

    protected void updateDetailsText() {
        if (this.detailsEditor == null) {
            return;
        }
        StringBuffer desc = new StringBuffer();
        List docs = (List)this.getProperty("documentlinks");
        if (docs != null && docs.size() > 0) {
            for (int i = 0; i < docs.size(); ++i) {
                String msg = (String)docs.get(i);
                if (!msg.startsWith("http:")) {
                    desc.append(msg);
                    desc.append("<p>");
                    continue;
                }
                desc.append("<a href=\"" + msg + "\">" + msg + "</a><p>");
            }
        }
        desc.append(this.getFullDescription());
        this.detailsEditor.setText(desc.toString());
        GuiUtils.scrollToTop(this.detailsEditor);
    }

    public GeoSelectionPanel doMakeGeoSelectionPanel() {
        return this.doMakeGeoSelectionPanel(true, null);
    }

    public GeoSelectionPanel doMakeGeoSelectionPanel(boolean forProperties) {
        return this.doMakeGeoSelectionPanel(forProperties, null);
    }

    public GeoSelectionPanel doMakeGeoSelectionPanel(boolean forProperties, GeoSelection geoSelection) {
        boolean enabled = true;
        if (geoSelection == null) {
            geoSelection = this.getDataSelection().getGeoSelection(true);
        } else {
            enabled = true;
        }
        return new GeoSelectionPanel(new GeoSelection(geoSelection), forProperties, enabled, this.canDoGeoSelectionStride(), this.canDoGeoSelectionMap(), this.getSampleDataProjection(), this.getExtraGeoSelectionComponent());
    }

    protected JComponent getExtraGeoSelectionComponent() {
        return null;
    }

    protected ProjectionImpl getSampleDataProjection() {
        return null;
    }

    protected boolean canDoGeoSelectionMap() {
        return true;
    }

    public boolean applyProperties() {
        String newName = this.nameFld.getText().trim();
        if (!Misc.equals(newName, this.name.trim())) {
            System.err.println("newName:" + newName + ": name:" + this.name);
            this.everChangedName = true;
        }
        this.setName(newName);
        if (this.properties != null) {
            this.properties.put("TITLE", newName);
            this.properties.put("name", newName);
        }
        this.setAlias(this.aliasFld.getText().trim());
        if (this.dsw != null) {
            this.setDateTimeSelection(this.dsw.getSelectedDateTimes());
            this.getIdv().getIdvUIManager().dataSourceTimeChanged(this);
        }
        if (this.geoSelectionPanel != null) {
            GeoSelection geoSubset = this.getDataSelection().getGeoSelection(true);
            if (!this.geoSelectionPanel.applyProperties(geoSubset)) {
                return false;
            }
            log_.debug("data selection:" + this.getDataSelection());
        }
        if (this.canPoll()) {
            if (!this.pollingInfo.applyProperties()) {
                return false;
            }
            boolean restart = this.pollingInfo.getIsActive();
            this.stopPolling();
            if (restart) {
                this.startPolling();
            }
        }
        if (this.cacheDataToDiskCbx != null) {
            this.setCacheDataToDisk(this.cacheDataToDiskCbx.isSelected());
            this.setCacheClearDelay((long)(1000.0 * new Double(this.cacheClearDelayFld.getText().trim())));
        }
        boolean useDisplayArea = false;
        if (this.geoSelectionPanel != null) {
            useDisplayArea = this.geoSelectionPanel.getUseDisplayArea();
        }
        this.properties.put("Match_Display_Area", useDisplayArea);
        return true;
    }

    protected void addActions(List actions) {
        AbstractAction a = null;
        a = new AbstractAction("Reload Data"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        Misc.run(DataSourceImpl.this, "reloadData");
                    }
                });
            }
        };
        actions.add(a);
        if (this.canChangeData()) {
            a = new AbstractAction("Change Data"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Misc.run(DataSourceImpl.this.getIdv().getIdvUIManager(), "changeState", DataSourceImpl.this);
                }
            };
            actions.add(a);
        }
        this.makeSaveLocalActions(actions);
        if (this.canDoFieldMask()) {
            a = new AbstractAction("Write Field Mask Plugin"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Misc.run(new Runnable(){

                        @Override
                        public void run() {
                            Misc.run(DataSourceImpl.this, "writeFieldMaskFile");
                        }
                    });
                }
            };
            actions.add(a);
        }
    }

    protected void makeSaveLocalActions(List actions) {
        if (this.canSaveDataToLocalDisk()) {
            AbstractAction a = new AbstractAction("Make Data Source Local"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Misc.run(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DataSourceImpl.this.saveDataToLocalDisk();
                            }
                            catch (Exception exc) {
                                DataSourceImpl.this.logException("Writing data to local disk", exc);
                            }
                        }
                    });
                }
            };
            actions.add(a);
        }
    }

    private void initPolling() {
        if (this.haveInitedPolling) {
            return;
        }
        this.haveInitedPolling = true;
        if (!this.canPoll()) {
            return;
        }
        if (this.descriptor == null) {
            return;
        }
        PollingInfo pollingInfo = this.getPollingInfo();
        if (pollingInfo != null) {
            if (pollingInfo.getFilePattern() == null) {
                pollingInfo.setFilePattern(this.descriptor.getPatterns());
            }
            if (pollingInfo.getIsActive()) {
                this.startPolling();
            }
        }
    }

    protected javax.swing.filechooser.FileFilter getFileFilterForPolling() {
        String filePattern = null;
        if (this.pollingInfo != null) {
            filePattern = this.pollingInfo.getFilePattern();
        }
        if (filePattern == null) {
            filePattern = this.getProperty("prop.filepattern", null);
        }
        if (filePattern == null) {
            filePattern = this.descriptor.getPatterns();
        }
        return new PatternFileFilter(filePattern, false, this.pollingInfo != null ? this.pollingInfo.getIsHiddenOk() : true);
    }

    protected File getLocationForPolling() {
        return null;
    }

    protected List getLocationsForPolling() {
        File f = this.getLocationForPolling();
        if (f != null) {
            return Misc.newList(f.toString());
        }
        return null;
    }

    public boolean canPoll() {
        return true;
    }

    private void showPollingPropertiesDialog() {
    }

    protected boolean isPolling() {
        return this.getPollingInfo().getIsActive();
    }

    public void setPollingInfo(PollingInfo value) {
        this.pollingInfo = value;
    }

    public PollingInfo getPollingInfo() {
        List files;
        if (this.pollingInfo == null) {
            this.pollingInfo = (PollingInfo)this.getProperty("prop.pollinfo");
        }
        if (this.pollingInfo == null) {
            this.pollingInfo = new PollingInfo();
            this.pollingInfo.setInterval(600000L);
            this.pollingInfo.setDontLookForNewFiles();
            files = this.getLocationsForPolling();
            if (files != null && files.size() > 0) {
                File f = new File(files.get(0).toString());
                if (!f.exists()) {
                    this.pollingInfo.setForFiles(false);
                }
            } else {
                this.pollingInfo.setForFiles(false);
            }
        }
        if (this.pollingInfo.getForFiles() && !this.pollingInfo.hasFiles() && (files = this.getLocationsForPolling()) != null) {
            this.pollingInfo.setFilePaths(new ArrayList(files));
        }
        return this.pollingInfo;
    }

    protected boolean hasPollingInfo() {
        return this.pollingInfo != null;
    }

    public void setDirectory(String n) {
    }

    public void setPollLocation(String value) {
    }

    protected List convertToFilesIfDirectory(List sources) {
        File f;
        if (sources.size() == 1 && (f = new File(sources.get(0).toString())).isDirectory()) {
            File mostRecent = IOUtil.getMostRecentFile(f, this.getFileFilterForPolling());
            if (mostRecent != null) {
                sources = Misc.newList(mostRecent.toString());
            } else {
                return new ArrayList();
            }
        }
        return sources;
    }

    protected List getMostRecentFiles(File dir, int cnt) {
        Trace.call1("mostRecent");
        if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        javax.swing.filechooser.FileFilter filter = this.getFileFilterForPolling();
        Trace.call1("listFiles");
        File[] allFiles = dir.listFiles((FileFilter)((Object)filter));
        Trace.call2("listFiles");
        Trace.msg("#files=" + allFiles.length);
        Trace.call1("sort");
        File[] sorted = IOUtil.sortFilesOnAge(allFiles, true);
        Trace.call2("sort");
        ArrayList<File> files = new ArrayList<File>();
        int total = 0;
        for (int i = 0; i < sorted.length && total < cnt; ++total, ++i) {
            files.add(sorted[i]);
        }
        Trace.call2("mostRecent");
        return files;
    }

    public void setAskToUpdate(boolean value) {
    }

    public void setDataIsRelative(boolean value) {
    }

    @Override
    public void setDataIsEditable(boolean value) {
        this.dataIsEditable = value;
    }

    @Override
    public boolean getDataIsEditable() {
        return this.dataIsEditable;
    }

    @Override
    public List getDataPaths() {
        return null;
    }

    public void setDataEditableStrings(List strings) {
    }

    public void setDataRelativeStrings(List strings) {
        this.setDataEditableStrings(strings);
    }

    public List getPathsThatCanBeRelative() {
        return null;
    }

    public void setRelativePaths(List value) {
        this.relativePaths = value;
    }

    public List getRelativePaths() {
        return this.relativePaths;
    }

    @Override
    public void updateState(Object newObject, Hashtable newProperties) {
        if (newProperties != null) {
            if (this.properties != null) {
                this.properties.putAll(newProperties);
            } else {
                this.properties = newProperties;
            }
            String v = this.getProperty("TITLE", null);
            if (v == null) {
                v = this.getProperty("name", null);
            }
            if (v != null) {
                this.name = v;
            }
        }
    }

    @Override
    public void resetTmpState() {
        this.tmpPaths = null;
        this.setDataIsEditable(false);
    }

    @Override
    public void setTmpPaths(List value) {
        this.tmpPaths = value;
    }

    @Override
    public List getTmpPaths() {
        return this.tmpPaths;
    }

    public static String getNameForDataSource(DataSource ds, int length, boolean alwaysDoIt) {
        String name = ds.toString();
        if (name == null) {
            name = "";
        }
        if (name.length() < length) {
            return name;
        }
        if (new File(name).exists() || name.startsWith("http:") || name.startsWith("dods:")) {
            int index;
            boolean seenSeparator = false;
            for (index = name.length() - 1; index >= 0; --index) {
                char c = name.charAt(index);
                if (c == File.separatorChar || c == '/') {
                    seenSeparator = true;
                    break;
                }
                if (seenSeparator && name.length() - index >= length) break;
            }
            if (index == 0 || index == -1) {
                return name;
            }
            return "..." + name.substring(index);
        }
        if (!alwaysDoIt) {
            return name;
        }
        return name.substring(0, length) + "...";
    }

    public void setCacheDataToDisk(boolean value) {
        this.cacheDataToDisk = value;
    }

    public boolean getCacheDataToDisk() {
        return this.cacheDataToDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataCachePath() {
        if (this.getDataContext() == null) {
            return null;
        }
        Object object = this.DATACACHEPATH_MUTEX;
        synchronized (object) {
            if (this.dataCachePath == null) {
                String uniqueName = "data_" + Misc.getUniqueId();
                String tmp = IOUtil.joinDir(this.getIdv().getDataManager().getDataCacheDirectory(), uniqueName);
                IOUtil.makeDir(tmp);
                try {
                    new File(tmp).deleteOnExit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dataCachePath = tmp;
            }
        }
        return this.dataCachePath;
    }

    public void setCacheClearDelay(long value) {
        this.cacheClearDelay = value;
    }

    public long getCacheClearDelay() {
        return this.cacheClearDelay;
    }

    public boolean showPasswordDialog(String title, String label) {
        if (!LogUtil.getInteractiveMode()) {
            throw new IllegalStateException("Cannot show dialog in non-interactive mode");
        }
        JTextField nameFld = new JTextField(this.getUserName() != null ? this.getUserName() : "", 10);
        JTextField passwordFld = new JTextField(this.getPassword() != null ? this.getPassword() : "", 10);
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("User Name:"), nameFld, GuiUtils.rLabel("Password:"), passwordFld}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        if (!GuiUtils.showOkCancelDialog(null, title, contents = GuiUtils.inset((Component)GuiUtils.topCenter(new JLabel(label), contents), 5), null)) {
            return false;
        }
        this.setUserName(nameFld.getText().trim());
        this.setPassword(passwordFld.getText().trim());
        return true;
    }

    public void setUserName(String value) {
        this.userName = value;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEverChangedName(boolean value) {
        this.everChangedName = value;
    }

    public boolean getEverChangedName() {
        return this.everChangedName;
    }

    @Override
    public void setDefaultSave(boolean defaultsave) {
        this.defaultSave = defaultsave;
    }

    public boolean getDefaultSave() {
        return this.defaultSave;
    }

    static {
        outstandingGetDataCalls = 0;
        MUTEX_OUTSTANDINGGETDATACALLS = new Object();
        cnt = 0;
    }
}

