/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.DataManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.PatternFileFilter;

public class DataSourceDescriptor {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DataSourceDescriptor.class.getName());
    protected String id;
    protected DataManager manager;
    protected Class factoryClass;
    protected Hashtable properties;
    protected String label;
    protected boolean fileSelection = false;
    protected boolean doesMultiples = false;
    protected String patterns;
    private FileFilter patternFilter;
    private String ncmlTemplate;
    private boolean standalone = false;

    public DataSourceDescriptor() {
    }

    public DataSourceDescriptor(String id, String label, DataManager manager, Class factory, String patterns, boolean fileSelection, boolean doesMultiples, Hashtable props) {
        this.id = id;
        this.label = label;
        this.manager = manager;
        this.patterns = patterns;
        this.fileSelection = fileSelection;
        this.doesMultiples = doesMultiples;
        this.factoryClass = factory;
        this.properties = props;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceDescriptor)) {
            return false;
        }
        DataSourceDescriptor that = (DataSourceDescriptor)o;
        return this.id.equals(that.id);
    }

    public DataContext getDataContext() {
        return this.manager != null ? this.manager.getDataContext() : null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDoesMultiples(boolean value) {
        this.doesMultiples = value;
    }

    public boolean getDoesMultiples() {
        return this.doesMultiples;
    }

    public DataManager getDataManager() {
        return this.manager;
    }

    public void setDataManager(DataManager m) {
        this.manager = m;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean getFileSelection() {
        return this.fileSelection;
    }

    public void setFileSelection(boolean fileSelection) {
        this.fileSelection = fileSelection;
    }

    public Class getFactoryClass() {
        return this.factoryClass;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable p) {
        this.properties = p;
    }

    public String getProperty(String property) {
        return (String)this.properties.get(property);
    }

    public String toString() {
        return "Label:" + this.label + " id:" + this.id + " class:" + this.factoryClass.getName();
    }

    public FileFilter getFilePatternFilter() {
        if (this.patterns == null) {
            return null;
        }
        if (this.patternFilter == null) {
            this.patternFilter = new PatternFileFilter(this.patterns);
        }
        return this.patternFilter;
    }

    public PatternFileFilter getPatternFileFilter() {
        return (PatternFileFilter)this.getFilePatternFilter();
    }

    public void setPatterns(String value) {
        this.patterns = value;
    }

    public String getPatterns() {
        return this.patterns;
    }

    public void setNcmlTemplate(String value) {
        this.ncmlTemplate = value;
    }

    public String getNcmlTemplate() {
        return this.ncmlTemplate;
    }

    public void setStandalone(boolean value) {
        this.standalone = value;
    }

    public boolean getStandalone() {
        return this.standalone;
    }
}

