/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.util.HashCodeUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import visad.DateTime;

public class DataSelection {
    public static final DataSelection NULL = null;
    public static final String PROP_DEFAULT_LEVELS = "default_levels";
    public static final String PROP_DATESELECTION = "date_selection";
    public static final String PROP_USESTIMEDRIVER = "Use_Display_Driver_Times";
    public static final String PROP_ASTIMEDRIVER = "As_Display_Driver_Times";
    public static final String PROP_CHOOSERTIMEMATCHING = "Chooser_Do_Time_Matching";
    public static final String PROP_TIMESUBSET = "Use DataChoice time subset";
    public static final String PROP_PROGRESSIVERESOLUTION = "Use_Progressive_Resolution";
    public static final String PROP_REGIONOPTION = "Region_Selection_Option";
    public static final String PROP_HASCORNER = "Region_Selection_Has_Conner";
    public static final String PROP_USEDISPLAYAREA = "Match_Display_Area";
    public static final String PROP_USEDEFAULTAREA = "Use_Default_Area";
    public static final String PROP_USESELECTEDAREA = "Use_Selected_Area";
    public static final String PROP_DEFAULTVIEW = "Default_View";
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DataSelection.class.getName());
    public static final int TIMESMODE_USETHIS = 0;
    public static final int TIMESMODE_USEOTHER = 1;
    private int timesMode = 1;
    private List times;
    private List<DateTime> timeDriverTimes;
    private Object fromLevel;
    private Object toLevel;
    private GeoSelection geoSelection;
    private Hashtable properties = new Hashtable();

    public DataSelection() {
        this((List)null);
    }

    public DataSelection(Object fromLevel, Object toLevel) {
        this.fromLevel = fromLevel;
        this.toLevel = toLevel;
    }

    public DataSelection(int zStride) {
        this.geoSelection = new GeoSelection(null, 1, 1, zStride);
    }

    public DataSelection(int xStride, int yStride, int zStride) {
        this.geoSelection = new GeoSelection(null, xStride, yStride, zStride);
    }

    public DataSelection(boolean setDefaults) {
        this((List)null);
        GeoLocationInfo bbox;
        if (setDefaults && (bbox = GeoSelection.getDefaultBoundingBox()) != null) {
            this.geoSelection = new GeoSelection(bbox);
        }
    }

    public DataSelection(List times) {
        this(times, 1);
    }

    public DataSelection(List times, int timesMode) {
        this.times = Misc.cloneList(times);
        this.timesMode = timesMode;
    }

    public DataSelection(DataSelection that) {
        if (that != null) {
            this.times = Misc.cloneList(that.times);
            if (that.timeDriverTimes != null) {
                this.timeDriverTimes = Misc.cloneList(that.timeDriverTimes);
            }
            this.timesMode = that.timesMode;
            if (that.geoSelection != null) {
                this.geoSelection = new GeoSelection(that.geoSelection);
            }
            this.fromLevel = that.fromLevel;
            this.toLevel = that.toLevel;
            this.properties = (Hashtable)that.properties.clone();
        }
    }

    public void setXYStride(int stride) {
        this.getGeoSelection(true).setXStride(stride);
        this.getGeoSelection(true).setYStride(stride);
    }

    public void setXStride(int stride) {
        this.getGeoSelection(true).setXStride(stride);
    }

    public void setYStride(int stride) {
        this.getGeoSelection(true).setYStride(stride);
    }

    public void setZStride(int stride) {
        this.getGeoSelection(true).setZStride(stride);
    }

    public void setBounds(double north, double west, double south, double east) {
        this.getGeoSelection(true).setBoundingBox(new GeoLocationInfo(north, west, south, east));
    }

    private void setTimesFromSelection(DataSelection other) {
        this.setTimes(other.getTimes());
        this.timesMode = other.timesMode;
    }

    public static DataSelection merge(DataSelection higherPriority, DataSelection lowerPriority) {
        if (lowerPriority == null && higherPriority == null) {
            return new DataSelection();
        }
        if (lowerPriority == null) {
            return new DataSelection(higherPriority);
        }
        if (higherPriority == null) {
            return new DataSelection(lowerPriority);
        }
        DataSelection newSelection = new DataSelection();
        Hashtable props = new Hashtable(lowerPriority.properties);
        props.putAll(higherPriority.properties);
        newSelection.setProperties(props);
        GeoSelection newGeoSelection = GeoSelection.merge(higherPriority.geoSelection, lowerPriority.geoSelection);
        newSelection.setGeoSelection(newGeoSelection);
        if (higherPriority.fromLevel != null) {
            newSelection.fromLevel = higherPriority.fromLevel;
            newSelection.toLevel = higherPriority.toLevel;
        } else {
            newSelection.fromLevel = lowerPriority.fromLevel;
            newSelection.toLevel = lowerPriority.toLevel;
        }
        if (higherPriority.timeDriverTimes != null) {
            newSelection.setTheTimeDriverTimes(higherPriority.timeDriverTimes);
        } else {
            newSelection.setTheTimeDriverTimes(lowerPriority.timeDriverTimes);
        }
        if (higherPriority.hasTimes()) {
            newSelection.setTimesFromSelection(higherPriority);
        } else if (lowerPriority.hasTimes()) {
            newSelection.setTimesFromSelection(lowerPriority);
        }
        return newSelection;
    }

    public boolean getUseThisTimes() {
        return this.timesMode == 0;
    }

    public void setTimesMode(int mode) {
        this.timesMode = mode;
    }

    public int getTimesMode() {
        return this.timesMode;
    }

    public DataSelection cloneMe() {
        return new DataSelection(this);
    }

    public boolean hasTimes() {
        return this.getUseThisTimes() || this.times != null && !this.times.isEmpty();
    }

    public void setTimes(List selectedTimes) {
        this.times = Misc.cloneList(selectedTimes);
    }

    public List getTimes() {
        return this.times;
    }

    public int hashCode() {
        return HashCodeUtils.hash(HashCodeUtils.hash(Misc.hashcode(this.times), Misc.hashcode(this.properties)), Misc.hashcode(this.geoSelection));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSelection)) {
            return false;
        }
        DataSelection that = (DataSelection)o;
        return Misc.equals(this.times, that.times) && Misc.equals(this.properties, that.properties) && Misc.equals(this.geoSelection, that.geoSelection) && Misc.equals(this.fromLevel, that.fromLevel) && Misc.equals(this.toLevel, that.toLevel);
    }

    public String toString() {
        return "bounds:" + this.geoSelection + ", has TimeDriver times: " + (this.getTimeDriverTimes() != null);
    }

    public void setLevel(Object level) {
        this.setLevelRange(level, level);
    }

    public void setLevelRange(Object fromLevel, Object toLevel) {
        this.fromLevel = fromLevel;
        this.toLevel = toLevel;
    }

    public void setFromLevel(Object value) {
        this.fromLevel = value;
    }

    public Object getFromLevel() {
        return this.fromLevel;
    }

    public void setToLevel(Object value) {
        this.toLevel = value;
    }

    public Object getToLevel() {
        return this.toLevel;
    }

    public void setGeoSelection(GeoSelection value) {
        this.geoSelection = value;
    }

    public GeoSelection getGeoSelection() {
        return this.geoSelection;
    }

    public GeoSelection getGeoSelection(boolean createIfNeeded) {
        if (createIfNeeded && this.geoSelection == null) {
            this.geoSelection = new GeoSelection();
        }
        return this.geoSelection;
    }

    public void setProperties(Hashtable value) {
        this.properties = value;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void removeProperty(Object key) {
        this.properties.remove(key);
    }

    public boolean getProperty(String name, boolean dflt) {
        Object o = this.getProperty(name);
        if (o == null) {
            return dflt;
        }
        return new Boolean(o.toString());
    }

    public String getProperty(String name, String dflt) {
        Object o = this.getProperty(name);
        if (o == null) {
            return dflt;
        }
        return o.toString();
    }

    public void putProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public void setTheTimeDriverTimes(List<DateTime> value) {
        this.timeDriverTimes = value;
    }

    public List<DateTime> getTimeDriverTimes() {
        return this.timeDriverTimes;
    }
}

