/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataCategory;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class DataOperand {
    private static final String PROP_CATEGORIES = "categories";
    private static final String PROP_MULTIPLE = "multiple";
    private static final String PROP_PATTERN = "pattern";
    private static final String PROP_DESCRIPTION = "description";
    public static final String PROP_LEVEL = "level";
    private static final String PROP_ISUSER = "isuser";
    private static final String PROP_LABEL = "label";
    private static final String PROP_DATASOURCE = "datasource";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_TIMES = "times";
    private String name;
    private List categories;
    private Object data;
    Hashtable properties = new Hashtable();

    public DataOperand(String name) {
        this(name, null);
    }

    public DataOperand(String name, Object data) {
        int idx2;
        this.name = name;
        this.data = data;
        int idx1 = name.indexOf("[");
        if (idx1 >= 0 && (idx2 = name.indexOf("]")) > idx1) {
            String props = name.substring(idx1 + 1, idx2);
            this.properties.putAll(Misc.parseProperties(props, ","));
        }
    }

    public DataOperand(String name, String description, List categories, boolean multiple) {
        this.name = name;
        this.putCategories(categories);
        if (description != null) {
            this.putDescription(description);
        }
        this.putMultiple(multiple);
    }

    public void putDescription(String desc) {
        this.properties.put(PROP_DESCRIPTION, desc);
    }

    public String getDescription() {
        String desc = (String)this.properties.get(PROP_DESCRIPTION);
        if (desc == null) {
            desc = (String)this.properties.get(PROP_LABEL);
        }
        if (desc == null) {
            return this.getParamName();
        }
        return desc;
    }

    public void putPattern(String pattern) {
        this.properties.put(PROP_PATTERN, pattern);
    }

    public String getPattern() {
        return (String)this.properties.get(PROP_PATTERN);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataOperand)) {
            return false;
        }
        return Misc.equals(this.name, ((DataOperand)o).name) && Misc.equals(this.data, ((DataOperand)o).data);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void putCategories(List categories) {
        this.categories = categories;
    }

    public List getCategories() {
        if (this.categories != null) {
            return this.categories;
        }
        String catString = (String)this.properties.get(PROP_CATEGORIES);
        if (catString == null) {
            return null;
        }
        return DataCategory.parseCategories(catString, false);
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setData(Object value) {
        this.data = value;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isBound() {
        return this.data != null;
    }

    public void putMultiple(boolean b) {
        this.properties.put(PROP_MULTIPLE, "" + b);
    }

    public boolean getMultiple() {
        String isMultiple = (String)this.properties.get(PROP_MULTIPLE);
        if (isMultiple == null) {
            return false;
        }
        return isMultiple.trim().equals("true");
    }

    public boolean isPersistent() {
        return !Misc.equals(this.getProperty("persistent"), "false");
    }

    public boolean isUser() {
        if (this.name.startsWith("user_")) {
            return true;
        }
        String isUser = (String)this.properties.get(PROP_ISUSER);
        if (isUser == null) {
            return false;
        }
        return isUser.trim().equals("true");
    }

    public String getDataSourceName() {
        return (String)this.properties.get(PROP_DATASOURCE);
    }

    public String getUserDefault() {
        return (String)this.properties.get(PROP_DEFAULT);
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public String getParamName() {
        int bracketIndex = this.name.lastIndexOf("[");
        if (bracketIndex >= 0) {
            return this.name.substring(0, bracketIndex);
        }
        return this.name;
    }

    public String getLabel() {
        String label = (String)this.properties.get(PROP_LABEL);
        if (label == null && (label = this.getParamName()).startsWith("user_")) {
            label = label.substring(5);
        }
        return label;
    }

    public String makeLegalJython() {
        String op = this.name;
        int idx1 = op.indexOf("[");
        int idx2 = op.indexOf("]");
        if (idx1 >= 0 && idx2 > idx1) {
            String internals = op.substring(idx1 + 1, idx2);
            StringBuffer good = new StringBuffer("_");
            char[] chars = internals.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isJavaIdentifierPart(chars[i])) {
                    good.append(chars[i]);
                    continue;
                }
                if (chars[i] == ' ') continue;
                good.append('_');
            }
            good.append("_");
            op = op.substring(0, idx1).trim() + good + op.substring(idx2 + 1).trim();
        }
        op = StringUtil.replace(op, ":", "_");
        return op;
    }

    public List getTimeIndices() {
        String timeString = (String)this.properties.get(PROP_TIMES);
        if (timeString == null) {
            return null;
        }
        List<String> timeStrings = StringUtil.split(timeString, ";", true, true);
        ArrayList<Integer> timeIndices = new ArrayList<Integer>();
        for (int timeIdx = 0; timeIdx < timeStrings.size(); ++timeIdx) {
            timeIndices.add(new Integer(timeStrings.get(timeIdx).toString()));
        }
        return timeIndices;
    }

    public static void main(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            new DataOperand(argv[i]);
        }
    }
}

