/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import edu.wisc.ssec.mcidas.adde.AddeURLStreamHandler;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPSession;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.iosp.gempak.GempakGridParameterTable;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.xml.RuntimeConfigParser;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceFactory;
import ucar.unidata.data.DataSourceResults;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DescriptorDataSource;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.VariableRenamer;
import ucar.unidata.util.AccountManager;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.UtcDate;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.SampledSet;
import visad.Unit;
import visad.VisADException;
import visad.data.DataCacheManager;
import visad.data.netcdf.StandardQuantityDB;
import visad.data.text.TextAdapter;

public class DataManager {
    static LogUtil.LogCategory log_;
    public static final String DATATYPE_UNKNOWN = "unknown";
    public static final String DATATYPE_ID = "datatypeid";
    public static final String PROP_SHOW_IN_TREE = "show_in_tree";
    public static final String PROP_CACHE_PERCENT = "idv.data.cache.percent";
    public static final String PROP_GEOSUBSET_BBOX = "idv.data.geosubset.bbox";
    public static final String PROP_NETCDF_CONVENTIONHANDLERS = "idv.data.netcdf.conventionhandlers";
    public static final String PROP_DEFAULT_DISPLAY = "default_display";
    public static final String TAG_DATASOURCES = "datasources";
    public static final String TAG_DATASOURCE = "datasource";
    public static final String TAG_PROPERTY = "property";
    public static final String ATTR_DOESMULTIPLES = "doesmultiples";
    public static final String ATTR_STANDALONE = "standalone";
    public static final String ATTR_NCMLTEMPLATE = "ncmltemplate";
    public static final String ATTR_ID = "id";
    public static final String ATTR_FACTORY = "factory";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PATTERNS = "patterns";
    public static final String ATTR_FILESELECTION = "fileselection";
    public static final String ATTR_VALUE = "value";
    public static final String PREF_GRIBINDEXINCACHE = "idv.data.gribindexincache";
    private DataContext dataContext;
    private Hashtable dataSourceToDefiningObject = new Hashtable();
    private Hashtable definingObjectToDataSource = new Hashtable();
    private ArrayList<DataSource> dataSources = new ArrayList();
    private static VariableRenamer variableRenamer;
    protected ArrayList descriptors = new ArrayList();
    private List<DataSourceDescriptor> standaloneDescriptors = new ArrayList<DataSourceDescriptor>();
    protected Hashtable idToDescriptor = new Hashtable();
    protected ArrayList allFilters = new ArrayList();
    protected ArrayList fileFilters = new ArrayList();
    protected Hashtable seenFilters = new Hashtable();
    protected ArrayList fileDataSourceIds = new ArrayList();
    protected ArrayList allDataSourceIds = new ArrayList();
    protected Hashtable dataSourceNameMap = new Hashtable();

    public DataManager(DataContext dataContext) {
        this.dataContext = dataContext;
        this.initURLStreamHandlers();
        this.initCache();
    }

    public String getDataCacheDirectory() {
        String dataCacheDir = IOUtil.joinDir(this.dataContext.getObjectStore().getUserTmpDirectory(), "cache/");
        IOUtil.makeDir(dataCacheDir);
        return dataCacheDir;
    }

    public void initResources(IdvResourceManager resourceManager) {
        String conventionHandlers;
        String[] visadProperties;
        this.loadDataSourceXml(resourceManager.getXmlResources(IdvResourceManager.RSC_DATASOURCE));
        this.loadIospResources(resourceManager);
        for (String visadProp : visadProperties = new String[]{"visad.java3d.imageByRef", "visad.java3d.geometryByRef", "visad.actionimpl.tracetime", "visad.actionimpl.tracestack", "visad.cachingcoordinatesystem.debugtime", "visad.java3d.textureNpot", "visad.data.arraycache.enabled", "visad.data.arraycache.lowerthreshold", "visad.data.arraycache.upperthreshold", "visad.data.arraycache.usedatacachemanager", "visad.contourFillSingleValueAsTexture"}) {
            System.setProperty(visadProp, this.dataContext.getIdv().getStateManager().getPreferenceOrProperty(visadProp, "false"));
        }
        SampledSet.setCacheSizeThreshold(this.dataContext.getIdv().getProperty("visad.sampledset.cachesizethreshold", 10000));
        if (!this.dataContext.getIdv().getServerMode()) {
            String nj22TmpFile = IOUtil.joinDir(this.dataContext.getObjectStore().getUserTmpDirectory(), "nj22/");
            IOUtil.makeDir(nj22TmpFile);
            DiskCache.setRootDirectory(nj22TmpFile);
            DiskCache.setCachePolicy(true);
            DiskCache2 dc = new DiskCache2(nj22TmpFile, false, -1, -1);
            boolean doCache = this.dataContext.getIdv().getStateManager().getPreferenceOrProperty(PREF_GRIBINDEXINCACHE, true);
            dc.setAlwaysUseCache(doCache);
            GribIndexCache.setDiskCache2(dc);
            GridServiceProvider.setIndexAlwaysInCache(doCache);
            DataCacheManager.getCacheManager().setCacheDir(new File(this.getDataCacheDirectory()));
            DataCacheManager.getCacheManager().setMemoryPercent(this.dataContext.getIdv().getStateManager().getPreferenceOrProperty(PROP_CACHE_PERCENT, 0.25));
            AccountManager accountManager = AccountManager.getGlobalAccountManager();
            if (accountManager == null) {
                accountManager = new AccountManager(this.dataContext.getIdv().getStore().getUserDirectory());
                AccountManager.setGlobalAccountManager(accountManager);
            }
            AccountManager provider = accountManager;
            try {
                HTTPSession.setGlobalCredentialsProvider(provider);
            }
            catch (HTTPException e) {
                e.printStackTrace();
            }
            String version = this.dataContext.getIdv().getStateManager().getVersion();
            if (version == null) {
                version = "xxx";
            }
            HTTPSession.setGlobalUserAgent("IDV " + version);
            HTTPSession.setGlobalSoTimeout(300000);
            HTTPSession.setGlobalConnectionTimeout(300000);
        }
        String defaultBoundingBoxString = this.dataContext.getIdv().getProperty(PROP_GEOSUBSET_BBOX, null);
        TextAdapter.addDateParser(new TextAdapter.DateParser(){

            @Override
            public DateTime createDateTime(String value, String format, TimeZone timezone) throws VisADException {
                if (format.endsWith("dh1") || format.endsWith("dh2") || format.endsWith("dh3") || format.endsWith("dh4")) {
                    int len = new Integer(format.substring(format.length() - 1));
                    int idx = (value = value.trim()).lastIndexOf(" ");
                    if (idx < 0) {
                        idx = 0;
                    }
                    String dh = value.substring(idx + 1);
                    int ptIdx = dh.length() - len;
                    dh = dh.substring(0, ptIdx) + "." + dh.substring(ptIdx);
                    while (dh.length() > 1 && dh.startsWith("0")) {
                        dh = dh.substring(1);
                    }
                    double hours = new Double(dh);
                    String HH = "" + (int)hours;
                    String mm = "" + (int)(60.0 * (hours - (double)((int)hours)));
                    format = format.replace("dh" + len, "HH:mm");
                    String newValue = value.trim().substring(0, idx + 1) + HH + ":" + mm;
                    return UtcDate.createDateTime(newValue, format, timezone);
                }
                return null;
            }
        });
        if (defaultBoundingBoxString != null) {
            List<String> toks = StringUtil.split(defaultBoundingBoxString, ",", true, true);
            if (toks.size() != 4) {
                System.err.println("Bad idv.geosubset property:" + defaultBoundingBoxString);
            } else {
                GeoSelection.setDefaultBoundingBox(new GeoLocationInfo(Misc.decodeLatLon(toks.get(0)), Misc.decodeLatLon(toks.get(1)), Misc.decodeLatLon(toks.get(2)), Misc.decodeLatLon(toks.get(3))));
            }
        }
        if ((conventionHandlers = this.dataContext.getIdv().getProperty(PROP_NETCDF_CONVENTIONHANDLERS, null)) != null) {
            List<String> tokens = StringUtil.split(conventionHandlers, ",", true, true);
            for (int i = 0; i < tokens.size(); ++i) {
                String token = tokens.get(i);
                List<String> subTokens = StringUtil.split(token, ":", true, true);
                if (subTokens.size() < 2) {
                    System.err.println("Bad convention handler token:" + token);
                    continue;
                }
                String className = subTokens.get(0).toString().trim();
                try {
                    Class handlerClass = Misc.findClass(className);
                    String conventionName = subTokens.get(1).toString().trim();
                    log_.debug("Loading convention handler: " + handlerClass.getName() + " for convention:" + conventionName);
                    CoordSysBuilder.registerConvention(conventionName, handlerClass);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    LogUtil.printException(log_, "Could not load convention class:" + className, cnfe);
                    continue;
                }
                catch (Exception exc) {
                    LogUtil.printException(log_, "Registering conventions", exc);
                }
            }
        }
    }

    public static void setDODSCompression(boolean compress) {
        DODSNetcdfFile.setAllowCompression(compress);
    }

    protected void loadGribResources(IdvResourceManager resourceManager) {
        this.loadIospResources(resourceManager);
    }

    protected void loadIospResources(IdvResourceManager resourceManager) {
        ResourceCollection grib1Resources = resourceManager.getResources(IdvResourceManager.RSC_GRIB1LOOKUPTABLES);
        for (int i = 0; i < grib1Resources.size(); ++i) {
            try {
                String grib1TableName = grib1Resources.get(i).toString();
                File grib1TableFile = new File(grib1TableName);
                if (!grib1TableFile.exists()) continue;
                Grib1ParamTables.addParameterTableLookup(grib1TableName);
                continue;
            }
            catch (Exception grib1TableName) {
                // empty catch block
            }
        }
        ResourceCollection njResources = resourceManager.getResources(IdvResourceManager.RSC_NJCONFIG);
        StringBuilder errlog = new StringBuilder();
        for (int i = 0; i < njResources.size(); ++i) {
            try {
                Object r = njResources.get(i);
                InputStream is = IOUtil.getInputStream(r.toString());
                if (is == null) continue;
                RuntimeConfigParser.read(is, errlog);
                continue;
            }
            catch (Exception r) {
                // empty catch block
            }
        }
        ResourceCollection gempakParameters = resourceManager.getResources(IdvResourceManager.RSC_GEMPAKGRIDPARAMTABLES);
        for (int i = 0; i < gempakParameters.size(); ++i) {
            try {
                String r = gempakParameters.get(i).toString();
                GempakGridParameterTable.addParameters(r);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        variableRenamer = new VariableRenamer(resourceManager);
    }

    private void initCache() {
        File cacheDir = new File(IOUtil.joinDir(this.dataContext.getObjectStore().getUserDirectory(), "datacache"));
        IOUtil.makeDir(cacheDir);
        CacheManager.setCacheDir(cacheDir);
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public void loadDataSourceXml(XmlResourceCollection resources) {
        if (resources == null) {
            return;
        }
        for (int i = 0; i < resources.size(); ++i) {
            Element root = resources.getRoot(i);
            if (root == null) continue;
            String tag = root.getTagName();
            if (tag.equals(TAG_DATASOURCES)) {
                XmlNodeList children = XmlUtil.getElements(root, TAG_DATASOURCE);
                for (int j = 0; j < children.getLength(); ++j) {
                    this.processDataSourceXml((Element)children.item(j));
                }
                continue;
            }
            if (tag.equals(TAG_DATASOURCE)) {
                this.processDataSourceXml(root);
                continue;
            }
            LogUtil.printMessage("Unknown tag name in datasources.xml:" + tag);
        }
    }

    public StringBuffer getDataSourceHtml() {
        StringBuffer html = new StringBuffer();
        try {
            ArrayList dataSources = this.getDataSources();
            for (int i = 0; i < dataSources.size(); ++i) {
                DataSource dataSource = (DataSource)dataSources.get(i);
                try {
                    html.append("\n<hr>");
                    html.append(dataSource.getFullDescription());
                    continue;
                }
                catch (Exception exc) {
                    html.append("Error getting datasource html:" + dataSource.getName());
                }
            }
            html.append("\n<hr>");
        }
        catch (Exception exc) {
            html.append("Error getting datasource html");
        }
        return html;
    }

    public static String getDatasourceXml(String type, String label, Class datasourceClass, Hashtable properties) throws Exception {
        return DataManager.getDatasourceXml(type, label, datasourceClass, properties, null);
    }

    public static String getDatasourceXml(String type, String label, Class datasourceClass, Hashtable properties, String[] attributes) throws Exception {
        Document doc = XmlUtil.makeDocument();
        Element root = doc.createElement(TAG_DATASOURCES);
        Element node = XmlUtil.create(TAG_DATASOURCE, root);
        node.setAttribute(ATTR_ID, type);
        node.setAttribute(ATTR_LABEL, label);
        node.setAttribute(ATTR_FACTORY, datasourceClass.getName());
        node.setAttribute(ATTR_FILESELECTION, "true");
        if (properties != null) {
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)properties.get(key);
                Element element = XmlUtil.create(doc, TAG_PROPERTY, node, value, new String[]{ATTR_NAME, key});
            }
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.length; i += 2) {
                node.setAttribute(attributes[i], XmlUtil.encodeString(attributes[i + 1]));
            }
        }
        return XmlUtil.toStringWithHeader(root);
    }

    private void processDataSourceXml(Element datasourceNode) {
        try {
            String ids = XmlUtil.getAttribute(datasourceNode, ATTR_ID);
            List<String> idList = StringUtil.split(ids);
            int count = 0;
            Iterator<String> iter = idList.iterator();
            while (iter.hasNext()) {
                ++count;
                String id = iter.next().toLowerCase();
                if (this.idToDescriptor.get(id) == null) {
                    String factory = XmlUtil.getAttribute(datasourceNode, ATTR_FACTORY);
                    String patterns = XmlUtil.getAttribute((Node)datasourceNode, ATTR_PATTERNS, (String)null);
                    String label = XmlUtil.getAttribute((Node)datasourceNode, ATTR_LABEL, "");
                    boolean fileSelection = XmlUtil.getAttribute((Node)datasourceNode, ATTR_FILESELECTION, false);
                    if (count > 1) {
                        fileSelection = false;
                    }
                    boolean doesMultiples = XmlUtil.getAttribute((Node)datasourceNode, ATTR_DOESMULTIPLES, false);
                    if (label != null && label.length() > 0 && this.dataSourceNameMap.get(label) == null) {
                        this.dataSourceNameMap.put(label, label);
                        this.allDataSourceIds.add(new TwoFacedObject((Object)label, id));
                    }
                    if (patterns != null) {
                        patterns = patterns.toLowerCase();
                        PatternFileFilter filter = null;
                        if (this.seenFilters.get(patterns) == null) {
                            this.seenFilters.put(patterns, patterns);
                            filter = new PatternFileFilter(patterns, (Object)id, label);
                        }
                        if (filter != null) {
                            this.allFilters.add(filter);
                        }
                        if (fileSelection && filter != null) {
                            this.fileFilters.add(filter);
                        }
                    }
                    if (fileSelection && label != null && label.length() > 0) {
                        this.fileDataSourceIds.add(new TwoFacedObject((Object)label, id));
                    }
                    Hashtable<String, String> properties = new Hashtable<String, String>();
                    XmlNodeList props = XmlUtil.getElements(datasourceNode, TAG_PROPERTY);
                    for (int propIdx = 0; propIdx < props.getLength(); ++propIdx) {
                        Element propNode = (Element)props.item(propIdx);
                        if (XmlUtil.hasAttribute(propNode, ATTR_VALUE)) {
                            properties.put(XmlUtil.getAttribute(propNode, ATTR_NAME), XmlUtil.getAttribute(propNode, ATTR_VALUE));
                            continue;
                        }
                        String value = XmlUtil.getChildText(propNode);
                        properties.put(XmlUtil.getAttribute(propNode, ATTR_NAME), value);
                    }
                    DataSourceDescriptor descriptor = new DataSourceDescriptor(id, label, this, Misc.findClass(factory), patterns, fileSelection, doesMultiples, properties);
                    descriptor.setStandalone(XmlUtil.getAttribute((Node)datasourceNode, ATTR_STANDALONE, false));
                    if (descriptor.getStandalone()) {
                        this.standaloneDescriptors.add(descriptor);
                    }
                    if (XmlUtil.hasAttribute(datasourceNode, ATTR_NCMLTEMPLATE)) {
                        descriptor.setNcmlTemplate(XmlUtil.getAttribute(datasourceNode, ATTR_NCMLTEMPLATE));
                    }
                    this.descriptors.add(descriptor);
                    this.idToDescriptor.put(id, descriptor);
                    continue;
                }
                break;
            }
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Processing data source", exc);
        }
    }

    public List<DataSourceDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public List<DataSourceDescriptor> getStandaloneDescriptors() {
        return this.standaloneDescriptors;
    }

    public List getFileDataSourceList() {
        return this.fileDataSourceIds;
    }

    public List getAllDataSourceIds() {
        return this.allDataSourceIds;
    }

    public ArrayList getDataSources() {
        return this.dataSources;
    }

    public boolean haveDataSource(DataSource dataSource) {
        return this.dataSources.contains(dataSource);
    }

    public boolean addDataSource(DataSource dataSource) {
        if (!this.haveDataSource(dataSource) && !dataSource.getInError()) {
            this.dataSources.add(dataSource);
            if (!this.dataContext.loadDataSource(dataSource)) {
                this.removeDataSource(dataSource);
                return false;
            }
            return true;
        }
        return false;
    }

    public void reloadAllDataSources() {
        LogUtil.message("Reloading all data");
        for (int i = 0; i < this.dataSources.size(); ++i) {
            DataSource dataSource = this.dataSources.get(i);
            dataSource.reloadData();
        }
    }

    public void removeAllDataSources() {
        ArrayList<DataSource> tmp = new ArrayList<DataSource>(this.dataSources);
        for (int i = 0; i < tmp.size(); ++i) {
            this.removeDataSource((DataSource)tmp.get(i));
        }
        this.dataSources = new ArrayList();
        this.dataSourceToDefiningObject = new Hashtable();
        this.definingObjectToDataSource = new Hashtable();
    }

    public void removeDataSource(DataSource dataSource) {
        this.dataSources.remove(dataSource);
        dataSource.doRemove();
        Object definingObject = this.dataSourceToDefiningObject.get(dataSource);
        if (definingObject != null) {
            this.definingObjectToDataSource.remove(definingObject);
            this.dataSourceToDefiningObject.remove(dataSource);
        }
    }

    public ArrayList getFileFilters() {
        return this.fileFilters;
    }

    public DataSourceDescriptor getCurrent(DataSourceDescriptor dds) {
        if (dds == null) {
            return null;
        }
        for (int i = 0; i < this.descriptors.size(); ++i) {
            DataSourceDescriptor descriptor = (DataSourceDescriptor)this.descriptors.get(i);
            if (!descriptor.equals(dds)) continue;
            return descriptor;
        }
        return dds;
    }

    private void checkMultiples(List definingObjects, List result, List filters, Hashtable properties) {
        if (!Misc.allStrings(definingObjects)) {
            return;
        }
        boolean didone = true;
        while (didone && definingObjects.size() > 1) {
            didone = false;
            for (int i = 0; i < this.descriptors.size(); ++i) {
                PatternFileFilter filter;
                DataSourceDescriptor descriptor = (DataSourceDescriptor)this.descriptors.get(i);
                if (!descriptor.getDoesMultiples() || (filter = descriptor.getPatternFileFilter()) == null) continue;
                ArrayList<String> workingList = null;
                ArrayList tmpList = new ArrayList(definingObjects);
                for (int stringIdx = 0; stringIdx < tmpList.size(); ++stringIdx) {
                    String s = (String)tmpList.get(stringIdx);
                    boolean match = filter.match(s);
                    if (!match) continue;
                    definingObjects.remove(s);
                    if (workingList == null) {
                        workingList = new ArrayList<String>();
                    }
                    workingList.add(s);
                }
                if (workingList == null) continue;
                Hashtable props = null;
                if (properties != null) {
                    props = (Hashtable)properties.get("prop.subproperties" + result.size());
                }
                result.add(new DataType(descriptor.getId(), workingList, props));
                didone = true;
            }
        }
        for (int stringIdx = 0; stringIdx < definingObjects.size(); ++stringIdx) {
            String s = (String)definingObjects.get(stringIdx);
            String dataType = this.findDataType(s, filters);
            if (dataType != null) {
                Hashtable props = null;
                if (properties != null) {
                    props = (Hashtable)properties.get("prop.subproperties" + result.size());
                }
                result.add(new DataType(dataType, s, props));
                continue;
            }
            result.add(new DataType(null, s));
        }
    }

    private List getDataTypes(Object definingObject, List filters, boolean returnErrorType, Hashtable properties) {
        ArrayList<DataType> result = new ArrayList<DataType>();
        if (definingObject instanceof List && ((List)definingObject).size() > 0) {
            this.checkMultiples((List)definingObject, result, filters, properties);
        }
        if (definingObject instanceof String) {
            String dataType = this.findDataType((String)definingObject, filters);
            if (dataType != null) {
                result.add(new DataType(dataType, definingObject));
            } else {
                if (!returnErrorType) {
                    return null;
                }
                result.add(new DataType(null, definingObject));
            }
        }
        return result;
    }

    private String findDataType(String definingObject, List filters) {
        String file = definingObject.trim().toLowerCase();
        int questionMarkIdx = file.indexOf("?");
        String substring = null;
        if (questionMarkIdx >= 0) {
            substring = file.substring(0, questionMarkIdx);
        }
        for (int i = 0; i < filters.size(); ++i) {
            PatternFileFilter filter = (PatternFileFilter)filters.get(i);
            boolean match = filter.match(file);
            if (!match && substring != null) {
                match = filter.match(substring);
            }
            if (!match) continue;
            return filter.getId().toString();
        }
        if (IOUtil.isHtmlFile(file)) {
            return "FILE.TEXT";
        }
        return null;
    }

    public boolean validDatasourceId(Object definingObject) {
        List dataTypes = this.getDataTypes(definingObject, this.allFilters, true, null);
        return dataTypes != null && dataTypes.size() != 0 && !dataTypes.get(0).equals(DATATYPE_UNKNOWN);
    }

    public boolean validDatasourceId(Object definingObject, Hashtable properties) {
        if (properties != null && properties.get(DATATYPE_ID) != null) {
            return true;
        }
        return this.validDatasourceId(definingObject);
    }

    private DataSource findDataSource(Object definingObject, Object lookupKey) {
        DataSource dataSource = (DataSource)this.definingObjectToDataSource.get(lookupKey);
        if (dataSource != null) {
            return dataSource;
        }
        for (int i = 0; i < this.dataSources.size(); ++i) {
            dataSource = this.dataSources.get(i);
            if (!dataSource.identifiedBy(definingObject)) continue;
            return dataSource;
        }
        return null;
    }

    public DataSource findDataSource(String name) {
        if (name == null) {
            name = "#0";
        }
        if (name.startsWith("#")) {
            int index = new Integer(name.substring(1).trim());
            if (index >= 0 && index < this.dataSources.size()) {
                return this.dataSources.get(index);
            }
            return null;
        }
        for (DataSource dataSource : this.dataSources) {
            if (!dataSource.identifiedBy(name)) continue;
            return dataSource;
        }
        for (DataSource dataSource : this.dataSources) {
            if (!dataSource.identifiedByName(name)) continue;
            return dataSource;
        }
        return null;
    }

    public DataSourceResults createDataSource(Object definingObject) {
        return this.createDataSource(definingObject, null);
    }

    public DataSourceResults createDataSource(Object definingObject, Hashtable properties) {
        return this.createDataSource(definingObject, null, properties);
    }

    public void createDataSourceAndAskForType(Object definingObject, Hashtable properties) {
        String dataType = this.dataContext.selectDataType(definingObject);
        if (dataType == null) {
            return;
        }
        do {
            try {
                DataSourceResults results = this.createDataSource(definingObject, dataType, properties);
                if (!results.anyFailed()) {
                    return;
                }
            }
            catch (BadDataException badDataException) {
                // empty catch block
            }
        } while ((dataType = this.dataContext.selectDataType(definingObject, "<html>Failed to load the data as the given type. Try again?</html>")) != null);
    }

    /*
     * Unable to fully structure code
     */
    public DataSourceResults createDataSource(Object definingObject, String dataType, Hashtable properties) {
        block40: {
            if (dataType != null && dataType.length() == 0) {
                dataType = null;
            }
            if (dataType == null && properties != null) {
                dataType = (String)properties.get("idv.datatype");
            }
            if (dataType == null && definingObject instanceof String && (file = (String)definingObject).startsWith("type:") && (index = (file = file.substring(5)).indexOf(":")) >= 0) {
                dataType = file.substring(0, index);
                definingObject = file.substring(index + 1);
            }
            if (properties == null) {
                properties = new Hashtable();
            }
            if (dataType == null) {
                dataType = (String)properties.get("datatypeid");
            }
            if ((existingDataSource = this.findDataSource(definingObject, lookupKey = new Object[]{definingObject, dataType})) != null) {
                existingDataSource.reloadData();
                return new DataSourceResults(existingDataSource, definingObject);
            }
            dataTypes = null;
            if (dataType != null) {
                if (definingObject instanceof List && Misc.allStrings((List)definingObject)) {
                    dsd = this.getDescriptor(dataType);
                    if (dsd != null && !dsd.getDoesMultiples()) {
                        sources = (List)definingObject;
                        dataTypes = new ArrayList<E>(sources.size());
                        for (i = 0; i < sources.size(); ++i) {
                            dataTypes.add(new DataType(dataType, sources.get(i), (Hashtable)properties.get("prop.subproperties" + dataTypes.size())));
                        }
                    } else {
                        dataTypes = Misc.newList(new DataType(dataType, definingObject));
                    }
                } else {
                    dataTypes = Misc.newList(new DataType(dataType, definingObject));
                }
            }
            if (dataTypes == null) {
                dataTypes = this.getDataTypes(definingObject, this.allFilters, false, properties);
            }
            results = new DataSourceResults();
            if (dataTypes != null && dataTypes.size() != 0 && !(definingObject instanceof ArrayList)) break block40;
            if (!(definingObject instanceof String)) ** GOTO lbl40
            overrideDataType = this.dataContext.selectDataType(definingObject);
            if (overrideDataType != null) {
                dataTypes = Misc.newList(new DataType(overrideDataType, definingObject));
            } else {
                return results;
lbl40:
                // 1 sources

                if (definingObject instanceof ArrayList) {
                    if (((ArrayList)definingObject).size() > 1 && dataTypes.get(0).toString().contains("null") && (overrideDataType = this.dataContext.selectDataType(((ArrayList)definingObject).get(0))) != null) {
                        for (i = 0; i < dataTypes.size(); ++i) {
                            dataTypes.set(i, new DataType(overrideDataType, definingObject));
                        }
                    }
                } else {
                    results.addFailed(definingObject, new BadDataException("Do not know how to handle the given data: " + definingObject));
                    return results;
                }
            }
        }
        for (i = 0; i < dataTypes.size(); ++i) {
            type = (DataType)dataTypes.get(i);
            if (type.isInError()) {
                results.addFailed(type.definingObject, new BadDataException("Do not know how to handle the given data: " + type.definingObject));
                break;
            }
            dataType = type.dataTypeId;
            definingObject = type.definingObject;
            descriptor = this.getDescriptor(dataType);
            if (descriptor == null) {
                results.addFailed(type.definingObject, new BadDataException("No factory for dataType: " + dataType));
                break;
            }
            LogUtil.consoleMessage("Loading in data source: " + descriptor.getLabel());
            LogUtil.message("Loading in data source: " + descriptor.getLabel());
            try {
                factoryClass = descriptor.getFactoryClass();
                if (factoryClass == null) {
                    results.addFailed(type.definingObject, new BadDataException("No factory for dataType: " + dataType));
                    break;
                }
                ctor = Misc.findConstructor(factoryClass, new Class[]{DataSourceDescriptor.class, definingObject.getClass(), Hashtable.class});
                if (ctor == null) {
                    results.addFailed(type.definingObject, new IllegalArgumentException("No constructor found for class:" + factoryClass.getName() + " data:" + definingObject.getClass()));
                    break;
                }
                propertiesToUse = type.properties != null ? type.properties : properties;
                factory = (DataSourceFactory)ctor.newInstance(new Object[]{descriptor, definingObject, propertiesToUse});
                dataSource = factory.getDataSource();
                if (dataSource != null) {
                    accountManager = AccountManager.getGlobalAccountManager();
                    numTries = 3;
                    while (true) {
                        try {
                            dataSource.initAfterCreation();
                        }
                        catch (WrapperException e) {
                            if (accountManager == null) {
                                throw e;
                            }
                            if (e.getException().getCause() != null) {
                                if (!e.getException().getCause().getMessage().contains("InvalidCredentialsException") && !e.getException().getCause().getCause().getMessage().contains("InvalidCredentialsException") && !e.getException().getCause().getCause().getCause().getMessage().contains("InvalidCredentialsException")) continue;
                                accountManager.removeUserNamePassword();
                                accountManager.clear();
                                dataSource.setInError(false);
                                if (--numTries > 0) continue;
                                dataSource.setInError(true);
                                throw e;
                            }
                            if (!e.getException().getMessage().contains("401 Unauthorized on URL=") && !e.getException().getMessage().contains("InvalidCredentialsException")) continue;
                            accountManager.removeUserNamePassword();
                            accountManager.clear();
                            dataSource.setInError(false);
                            if (--numTries <= 0) ** break;
                            continue;
                            dataSource.setInError(true);
                            throw e;
                        }
                        catch (Exception ee) {
                            throw ee;
                        }
                        break;
                    }
                    choices = dataSource.getDataChoices();
                    if (dataSource.getInError()) {
                        if (!dataSource.getNeedToShowErrorToUser()) break;
                        results.addFailed(definingObject, new BadDataException(dataSource.getErrorMessage()));
                        break;
                    }
                    if (this.addDataSource(dataSource)) {
                        lookupKey = new Object[]{definingObject, dataType};
                        this.definingObjectToDataSource.put(lookupKey, dataSource);
                        this.dataSourceToDefiningObject.put(dataSource, lookupKey);
                    } else if (this.haveDataSource(dataSource) && (idx = this.dataSources.indexOf(dataSource)) >= 0) {
                        this.dataSources.get(idx).reloadData();
                    }
                }
                results.addSuccess(dataSource, definingObject);
                continue;
            }
            catch (IllegalArgumentException iae) {
                results.addFailed(definingObject, new BadDataException("Cannot open file: " + definingObject, iae));
                break;
            }
            catch (InvocationTargetException ite) {
                results.addFailed(definingObject, new BadDataException("Error creating data source:" + dataType + " with: " + definingObject + "\n", ite.getTargetException()));
                break;
            }
            catch (WrapperException wexc) {
                results.addFailed(definingObject, new BadDataException("Error creating data source:" + dataType + " with: " + definingObject + "\n" + wexc.getMessage() + "\n", wexc.getException()));
                break;
            }
            catch (Throwable exc) {
                results.addFailed(definingObject, new BadDataException("Error creating data source:" + dataType + " with: " + definingObject + "\n", exc));
                break;
            }
        }
        return results;
    }

    public void initEncoder(XmlEncoder encoder, boolean forRead) {
        int i;
        encoder.defineObjectId(this, "datamanager");
        if (forRead) {
            for (i = 0; i < this.descriptors.size(); ++i) {
                DataSourceDescriptor descriptor = (DataSourceDescriptor)this.descriptors.get(i);
                encoder.defineObjectId(descriptor, "DESC:" + descriptor.getId());
                encoder.defineObjectId(descriptor, "DESC:" + descriptor.getId().toUpperCase());
                encoder.defineObjectId(descriptor, "desc:" + descriptor.getId());
            }
        }
        for (i = 0; i < this.dataSources.size(); ++i) {
            encoder.addSeedObject(this.dataSources.get(i));
        }
    }

    public DataSourceDescriptor getDescriptor(String dataType) {
        if (dataType == null) {
            return null;
        }
        return (DataSourceDescriptor)this.idToDescriptor.get(dataType.toLowerCase());
    }

    public String getProperty(String dataType, String property) {
        if (dataType == null) {
            return null;
        }
        DataSourceDescriptor descriptor = this.getDescriptor(dataType);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getProperty(property);
    }

    public boolean getProperty(String dataType, String property, boolean dflt) {
        String v = this.getProperty(dataType, property);
        if (v == null) {
            return dflt;
        }
        return new Boolean(v);
    }

    public static List<String> getNewVariableName(String varName) {
        return variableRenamer.renameVar(varName);
    }

    public void initURLStreamHandlers() {
        try {
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                @Override
                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if (protocol.equalsIgnoreCase("adde")) {
                        return new AddeURLStreamHandler();
                    }
                    if (protocol.equalsIgnoreCase("idvresource")) {
                        return new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL url) {
                                try {
                                    return IOUtil.getURL(url.getPath(), this.getClass()).openConnection();
                                }
                                catch (Exception exc) {
                                    LogUtil.logException("Handling idvresource", exc);
                                    return null;
                                }
                            }
                        };
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isFormulaDataSource(Object s) {
        return s instanceof DescriptorDataSource;
    }

    public static void main(String[] args) throws Exception {
        Trace.startTrace();
        Unit unit = DataUtil.parseUnit("k");
        RealType realType = DataUtil.makeRealType("temp", unit);
        Trace.call1("start");
        for (int i = 0; i < 2000000; ++i) {
            Real real = new Real(realType, 100.0, unit);
        }
        Trace.call2("start");
    }

    static {
        block2: {
            try {
                StandardQuantityDB standardQuantityDB = StandardQuantityDB.instance();
            }
            catch (Exception e) {
                if (!(e instanceof RuntimeException)) break block2;
                throw (RuntimeException)e;
            }
        }
        log_ = LogUtil.getLogInstance(DataManager.class.getName());
    }

    private class DataType {
        String dataTypeId;
        Object definingObject;
        Hashtable properties;

        public DataType(String dataTypeId, Object definingObject) {
            this(dataTypeId, definingObject, null);
        }

        public DataType(String dataTypeId, Object definingObject, Hashtable properties) {
            this.dataTypeId = dataTypeId;
            this.definingObject = definingObject;
            this.properties = properties;
        }

        public boolean isInError() {
            return this.dataTypeId == null;
        }

        public String toString() {
            return "data type: " + this.dataTypeId;
        }
    }
}

