/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.rmi.RemoteException;
import java.util.Hashtable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.util.LogUtil;
import visad.Data;
import visad.VisADException;

public class DataInstance {
    protected static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DataInstance.class.getName());
    private static int nextId = 0;
    private static Object ID_MUTEX = new Object();
    protected boolean haveBeenInitialized = false;
    protected boolean inError = false;
    protected DataChoice dataChoice;
    private Data data;
    protected DataSelection dataSelection;
    protected Hashtable myRequestProperties;

    public DataInstance(DataChoice dataChoice, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        this(dataChoice, dataSelection, requestProperties, null);
    }

    public DataInstance(DataChoice dataChoice, DataSelection dataSelection, Hashtable requestProperties, Data theData) throws VisADException, RemoteException {
        this.myRequestProperties = requestProperties;
        this.dataSelection = dataSelection;
        this.dataChoice = dataChoice;
        this.data = theData;
    }

    protected void init() throws VisADException, RemoteException {
        this.haveBeenInitialized = true;
    }

    public boolean needsInitialization() {
        return !this.haveBeenInitialized;
    }

    protected void checkInit() {
        if (!this.haveBeenInitialized) {
            try {
                this.init();
            }
            catch (Exception exc) {
                LogUtil.logException("Initialization of DataInstance", exc);
            }
        }
    }

    public synchronized void reInitialize() throws VisADException, RemoteException {
        this.inError = false;
        this.data = null;
        this.haveBeenInitialized = false;
        this.init();
    }

    public DataSelection getDataSelection() {
        return this.dataSelection;
    }

    public DataChoice getDataChoice() {
        return this.dataChoice;
    }

    public void setTheData(Data d) {
        this.data = d;
    }

    public Data getData() throws VisADException, RemoteException {
        return this.getData(this.dataSelection, this.myRequestProperties);
    }

    public Data getData(DataSelection dataSelection) throws VisADException, RemoteException {
        return this.getData(dataSelection, this.myRequestProperties);
    }

    public Data getData(DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        this.checkInit();
        if (this.data == null) {
            this.data = this.dataChoice.getData(dataSelection, requestProperties);
            if (this.data == null) {
                this.inError = true;
            }
        }
        return this.data;
    }

    protected void setData(Data newData) {
        this.data = newData;
    }

    public void setDataSelection(DataSelection dataSelection) {
        this.dataSelection = dataSelection;
    }

    public boolean dataOk() throws VisADException, RemoteException {
        if (this.inError) {
            return false;
        }
        return this.getData() != null;
    }

    public String getParamName() {
        return this.dataChoice.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getNextId() {
        Object object = ID_MUTEX;
        synchronized (object) {
            return nextId++;
        }
    }
}

