/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.util.LogUtil;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class DataGroup {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DataGroup.class.getName());
    private static final String TAG_PARAMGROUPS = "paramgroups";
    private static final String TAG_PARAMGROUP = "paramgroup";
    private static final String TAG_PARAMS = "params";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_PARAMPREFIX = "p";
    private static List groups;
    private static Hashtable groupMap;
    private String name;
    private String description = "";
    private List paramSets = new ArrayList();

    public DataGroup() {
    }

    public DataGroup(String groupName) {
        this.name = groupName;
    }

    public DataGroup(DataGroup that) {
        this.name = that.name;
        if (that.paramSets != null) {
            for (int i = 0; i < that.paramSets.size(); ++i) {
                ArrayList tmp = new ArrayList((List)that.paramSets.get(i));
                this.paramSets.add(tmp);
            }
        }
    }

    private void addParamSet(List l) {
        if (!this.paramSets.contains(l)) {
            this.paramSets.add(l);
        }
    }

    private void add(DataGroup that) {
        for (int i = 0; i < that.paramSets.size(); ++i) {
            List params = (List)this.paramSets.get(i);
            this.addParamSet(params);
        }
    }

    public static DataGroup getDataGroup(String groupName) {
        return (DataGroup)groupMap.get(groupName);
    }

    public static List getGroups() {
        return groups;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public List getParamSets() {
        return this.paramSets;
    }

    public void setParamSets(List l) {
        this.paramSets = l;
    }

    public static void init(XmlResourceCollection xrc) {
        DataGroup.init(xrc, false);
    }

    public static void init(XmlResourceCollection xrc, boolean andClear) {
        xrc.clearCache();
        if (andClear || groups == null) {
            groups = new ArrayList();
            groupMap = new Hashtable();
        }
        try {
            for (int i = 0; i < xrc.size(); ++i) {
                Element root = xrc.getRoot(i);
                if (root == null) continue;
                groups.addAll(DataGroup.readGroups(root, groupMap, true));
            }
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Initializing DataGroup", exc);
            return;
        }
    }

    public Element getElement(Document doc) {
        Element node = doc.createElement(TAG_PARAMGROUP);
        node.setAttribute(ATTR_NAME, this.getName());
        if (this.description != null) {
            node.setAttribute(ATTR_DESCRIPTION, this.getDescription());
        }
        for (int i = 0; i < this.paramSets.size(); ++i) {
            List params = (List)this.paramSets.get(i);
            Element child = doc.createElement(TAG_PARAMS);
            node.appendChild(child);
            for (int j = 0; j < params.size(); ++j) {
                child.setAttribute(ATTR_PARAMPREFIX + (j + 1), params.get(j).toString());
            }
        }
        return node;
    }

    public String toString() {
        if (this.description != null && this.description.length() > 0) {
            return this.description;
        }
        return this.name;
    }

    public static List readGroups(Element root, Hashtable groupMap, boolean merge) {
        ArrayList<DataGroup> groups = new ArrayList<DataGroup>();
        if (root.getTagName().equals("object")) {
            Object o = new XmlEncoder().toObject(root);
            if (o == null) {
                return groups;
            }
            if (o instanceof List) {
                List l = (List)o;
                for (int i = 0; i < l.size(); ++i) {
                    DataGroup other;
                    DataGroup dataGroup = (DataGroup)l.get(i);
                    if (merge && (other = (DataGroup)groupMap.get(dataGroup.getName())) != null) {
                        other.add(dataGroup);
                        continue;
                    }
                    groupMap.put(dataGroup.getName(), dataGroup);
                    groups.add(dataGroup);
                }
            }
            return groups;
        }
        List children = XmlUtil.findChildren(root, TAG_PARAMGROUP);
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String groupName = XmlUtil.getAttribute(child, ATTR_NAME);
            String desc = XmlUtil.getAttribute((Node)child, ATTR_DESCRIPTION, "");
            DataGroup group = null;
            if (merge) {
                group = (DataGroup)groupMap.get(groupName);
            }
            if (group == null) {
                group = new DataGroup(groupName);
                group.setDescription(desc);
                groupMap.put(groupName, group);
                groups.add(group);
            }
            List grandChildren = XmlUtil.findChildren(child, TAG_PARAMS);
            for (int j = 0; j < grandChildren.size(); ++j) {
                String param;
                int paramIdx = 1;
                Element grandchild = (Element)grandChildren.get(j);
                ArrayList<String> paramList = new ArrayList<String>();
                while ((param = XmlUtil.getAttribute((Node)grandchild, ATTR_PARAMPREFIX + paramIdx++, (String)null)) != null) {
                    paramList.add(param);
                }
                group.addParamSet(paramList);
            }
        }
        return groups;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getDescription() {
        return this.description;
    }
}

