/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChangeListener;
import ucar.unidata.data.DataSelection;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import visad.Data;
import visad.Real;
import visad.VisADException;

public abstract class DataChoice {
    private static Hashtable currentNamesMap = new Hashtable();
    private static List currentNames = new ArrayList();
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DataChoice.class.getName());
    public static final DataSelection NULL_DATASELECTION = null;
    public static final Hashtable NULL_PROPERTIES = null;
    public static final String PROP_REQUESTER = "prop.requester";
    public static final String PROP_ICON = "prop.icon";
    public static final Hashtable NULL_REQUESTPROPERTIES = null;
    protected Hashtable properties;
    private Hashtable fixedRequestProperties;
    protected DataChoice parent;
    protected Object id;
    protected String name;
    protected String description;
    List categories;
    DataSelection myDataSelection;

    public DataChoice() {
    }

    public DataChoice(DataChoice other) {
        this.id = other.id;
        if (other.properties != null) {
            this.properties = new Hashtable();
            this.properties.putAll(other.properties);
        }
        this.name = other.name;
        this.description = other.description;
        this.categories = new ArrayList(other.categories);
        if (other.myDataSelection != null) {
            this.myDataSelection = other.myDataSelection.cloneMe();
        }
        if (other.fixedRequestProperties != null) {
            this.fixedRequestProperties = (Hashtable)other.fixedRequestProperties.clone();
        }
    }

    public DataChoice(Object id, String name, String description, List categories) {
        this(id, name, description, categories, NULL_PROPERTIES);
    }

    public DataChoice(Object id, String name, String description, List categories, Hashtable properties) {
        this.id = id;
        this.name = name;
        this.description = description;
        if (this.description == null) {
            this.description = this.name;
        }
        if (this.description == null) {
            this.name = "Data";
            this.description = "Data";
        }
        this.properties = properties;
        this.categories = categories != null ? new ArrayList(categories) : new ArrayList();
        this.addParamNameToCategories();
    }

    public DataChoice(Object id, String description) {
        this(id, description, (List)null);
    }

    public DataChoice(Object id, String description, List categories) {
        this(id, description, description, categories);
    }

    public DataChoice(Object id, String description, DataCategory category) {
        this(id, description, Misc.newList(category));
    }

    public static void addCurrentName(Object name) {
        if (name == null || currentNamesMap.get(name) != null) {
            return;
        }
        currentNamesMap.put(name, name);
        currentNames.add(name);
    }

    public static List getCurrentNames() {
        return new ArrayList(currentNames);
    }

    public void initAfterUnPersistence(Hashtable properties) {
    }

    public void getFinalDataChoices(List dataChoices) {
    }

    public void getDataSources(List dataSources) {
    }

    protected void addParamNameToCategories() {
        boolean haveNonDisplay = false;
        for (int i = 0; i < this.categories.size() && !haveNonDisplay; ++i) {
            haveNonDisplay = !((DataCategory)this.categories.get(i)).getForDisplay();
        }
        if (!haveNonDisplay) {
            return;
        }
        this.categories.add(new DataCategory("param:" + this.name, false));
        String canonicalName = DataAlias.aliasToCanonical(this.name);
        if (canonicalName != null && !canonicalName.equals(this.name)) {
            this.categories.add(new DataCategory("param:" + canonicalName, false));
        }
    }

    public void setDataSelection(DataSelection dataSelection) {
        this.myDataSelection = dataSelection;
    }

    public DataSelection getDataSelection() {
        return this.myDataSelection;
    }

    public void setTimeSelection(List times) {
        if (this.myDataSelection == null) {
            this.myDataSelection = new DataSelection(times);
        } else {
            this.myDataSelection.setTimes(times);
        }
    }

    public void setLevelSelection(Real level) {
        if (this.myDataSelection == null) {
            this.myDataSelection = new DataSelection();
        }
        this.myDataSelection.setLevel(level);
    }

    public List getAllLevels() {
        return this.getAllLevels(null);
    }

    public List getAllLevels(DataSelection dataSelection) {
        return null;
    }

    public List getAllDateTimes() {
        if (this.myDataSelection != null) {
            return this.myDataSelection.getTimes();
        }
        return null;
    }

    public List getSelectedDateTimes() {
        if (this.myDataSelection != null) {
            return this.myDataSelection.getTimes();
        }
        return null;
    }

    public static List cloneDataChoices(List listOfChoices) {
        if (listOfChoices != null) {
            ArrayList<DataChoice> dataChoices = new ArrayList<DataChoice>();
            for (int i = 0; i < listOfChoices.size(); ++i) {
                DataChoice dc = (DataChoice)listOfChoices.get(i);
                if (dc == null) {
                    dataChoices.add(null);
                    continue;
                }
                dataChoices.add(dc.createClone());
            }
            return dataChoices;
        }
        return null;
    }

    public final DataChoice createClone() {
        return this.cloneMe();
    }

    public abstract DataChoice cloneMe();

    public DataChoice getParent() {
        return this.parent;
    }

    public void setParent(DataChoice parent) {
        this.parent = parent;
    }

    public boolean getForUser() {
        return this.getProperty("forUser", true);
    }

    public DataCategory getDisplayCategory() {
        if (this.categories == null) {
            return null;
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            DataCategory cat = (DataCategory)this.categories.get(i);
            if (!cat.getForDisplay()) continue;
            return cat;
        }
        return null;
    }

    public void addCategory(DataCategory newCategory) {
        this.categories.add(newCategory);
    }

    public List getCategories() {
        return this.categories;
    }

    public List getDataCategories() {
        return this.categories;
    }

    public List getDataCategories(boolean excludeDisplayCategories) {
        if (!excludeDisplayCategories) {
            return this.categories;
        }
        if (this.categories == null) {
            return null;
        }
        ArrayList<DataCategory> l = new ArrayList<DataCategory>();
        for (int i = 0; i < this.categories.size(); ++i) {
            DataCategory cat = (DataCategory)this.categories.get(i);
            if (cat.getForDisplay()) continue;
            l.add(cat);
        }
        return l;
    }

    public void setDataCategories(List categories) {
    }

    public void setCategories(List categories) {
        this.categories = categories == null ? new ArrayList() : categories;
    }

    public final Data getData(DataSelection incomingDataSelection) throws VisADException, RemoteException, DataCancelException {
        return this.getData(null, DataSelection.merge(incomingDataSelection, this.myDataSelection), null);
    }

    public final Data getData(DataSelection incomingDataSelection, Hashtable requestProperties) throws VisADException, RemoteException, DataCancelException {
        this.fixedRequestProperties = DataChoice.mergeRequestProperties(requestProperties, this.fixedRequestProperties);
        Hashtable tmp = null;
        if (this.fixedRequestProperties != null) {
            tmp = new Hashtable(this.fixedRequestProperties);
        }
        Data data = this.getData(null, DataSelection.merge(incomingDataSelection, this.myDataSelection), tmp);
        Enumeration keys = tmp.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            requestProperties.put(key, tmp.get(key));
        }
        return data;
    }

    protected abstract Data getData(DataCategory var1, DataSelection var2, Hashtable var3) throws VisADException, RemoteException, DataCancelException;

    public static Hashtable mergeRequestProperties(Hashtable incoming, Hashtable fixedRequestProperties) {
        Hashtable result = null;
        if (incoming == null) {
            result = fixedRequestProperties;
        } else if (fixedRequestProperties == null) {
            result = incoming;
        } else {
            result = new Hashtable(incoming);
            Enumeration keys = fixedRequestProperties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (result.get(key) != null) continue;
                result.put(key, fixedRequestProperties.get(key));
            }
        }
        if (result != null) {
            result = new Hashtable(result);
        }
        return result;
    }

    public int hashCode() {
        return Misc.hashcode(this.id) ^ Misc.hashcode(this.categories) ^ Misc.hashcode(this.myDataSelection);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataChoice)) {
            return false;
        }
        DataChoice that = (DataChoice)other;
        boolean idEquals = this.idEquals(that);
        return idEquals && Misc.equals(this.categories, that.categories) && Misc.equals(this.myDataSelection, that.myDataSelection);
    }

    public boolean basicallyEquals(DataChoice that) {
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        return this.idEquals(that);
    }

    private boolean idEquals(DataChoice that) {
        boolean idEquals = Misc.equals(this.id, that.id);
        if (!idEquals && this.id.getClass().equals(that.id.getClass()) && this.id.getClass().isArray()) {
            idEquals = Arrays.equals((Object[])this.id, (Object[])that.id);
        }
        return idEquals;
    }

    public String getStringId() {
        if (this.id == null) {
            return null;
        }
        return this.id.toString();
    }

    public String getIndexedName(int index) {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getFullDescription() {
        return "<b>Field:</b> " + this.getName() + " <b>(" + this.getDescription() + ")</b>";
    }

    public void setId(Object theId) {
        this.id = theId;
    }

    public Object getId() {
        return this.id;
    }

    public String toString() {
        return this.description;
    }

    public void setProperty(String name, boolean propertyValue) {
        this.setProperty(name, "" + propertyValue);
    }

    public void setObjectProperty(String name, Object propertyValue) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(name, propertyValue);
    }

    public void setProperty(String name, String propertyValue) {
        this.setObjectProperty(name, propertyValue);
    }

    public boolean getProperty(String name, boolean dflt) {
        return Misc.getProperty(this.properties, name, dflt);
    }

    public String getProperty(String name, String dflt) {
        String v = Misc.getProperty(this.properties, name, dflt);
        if (v != null) {
            v = v.trim();
        }
        return v;
    }

    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable newProperties) {
        if (newProperties == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.putAll(newProperties);
    }

    public abstract void addDataChangeListener(DataChangeListener var1);

    public abstract void removeDataChangeListener(DataChangeListener var1);

    public boolean isEndUserFormula() {
        return false;
    }

    public void setFixedRequestProperties(Hashtable value) {
        this.fixedRequestProperties = value;
    }

    public Hashtable getFixedRequestProperties() {
        return this.fixedRequestProperties;
    }
}

