/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class DataCategory {
    public static final DataCategory NULL = null;
    public static final String DIVIDER = "-";
    protected String name;
    protected DataCategory child;
    private List metaCategories;
    private String myPattern = null;
    public static final String CATEGORY_ANY = "*";
    public static final String CATEGORY_TEXT = "text";
    public static final String CATEGORY_HTML = "html";
    public static final String CATEGORY_DISPLAY = "DISPLAY";
    public static final String CATEGORY_GRID = "GRID";
    public static final String CATEGORY_POINT = "POINT";
    public static final String CATEGORY_VISAD = "VISAD";
    public static final String CATEGORY_IMAGE = "IMAGE";
    public static final String CATEGORY_3D = "3D";
    public static final String CATEGORY_2D = "2D";
    public static final String CATEGORY_RAOB = "RAOB";
    public static final String CATEGORY_SKEWT = "skewt";
    public static final String CATEGORY_SOUNDING = "Sounding";
    public static final String CATEGORY_POINTPLOT = "PointPlot";
    public static final String CATEGORY_TRACK = "Track";
    public static final String CATEGORY_GRIDSKEWT = "GRID_SKEWT";
    public static final String CATEGORY_RAOBSKEWT = "RAOB_SKEWT";
    public static final String CATEGORY_TRACKSKEWT = "TRACK_SKEWT";
    public static final String CATEGORY_COSMICSKEWT = "COSMIC_SKEWT";
    public static final String CATEGORY_GRIDSOUNDING = "GRID_SOUNDING";
    public static final String CATEGORY_ENSEMBLE = "ENSEMBLE";
    public static final String CATEGORY_RAOBSOUNDING = "RAOB_SOUNDING";
    public static final String CATEGORY_TRACKSOUNDING = "TRACK_SOUNDING";
    public static final String CATEGORY_TRAJECTORYSOUNDING = "TRAJECTORY_SOUNDING";
    public static final String CATEGORY_PROFILER_ONESTA = "PROFILER_ONESTA";
    public static final String CATEGORY_PROFILER_MULTISTA = "PROFILER_MULTISTA";
    public static final String CATEGORY_PROFILER_PLAN = "PROFILER_PLANVIEW";
    public static final String CATEGORY_PROFILER_3D = "PROFILER_3D";
    public static final DataCategory NONE_CATEGORY = new DataCategory("none", false);
    public static final DataCategory RAOB_SKEWT_CATEGORY = new DataCategory("RAOB_SKEWT", false);
    public static final DataCategory RAOB_SOUNDING_CATEGORY = new DataCategory("RAOB_SOUNDING", false);
    public static final DataCategory PROFILER_ONESTA_CATEGORY = new DataCategory("PROFILER_ONESTA", false);
    public static final DataCategory PROFILER_PLAN_CATEGORY = new DataCategory("PROFILER_PLANVIEW", false);
    public static final DataCategory GRID_3D_SKEWT_CATEGORY = new DataCategory("GRID_SKEWT", false);
    public static final DataCategory TRACK_SKEWT_CATEGORY = new DataCategory("TRACK_SKEWT", false);
    public static final DataCategory COSMIC_SKEWT_CATEGORY = new DataCategory("COSMIC_SKEWT", false);
    public static final DataCategory ENSEMBLE_CATEGORY = new DataCategory("ENSEMBLE", false);
    public static final DataCategory GRID_3D_SOUNDING_CATEGORY = new DataCategory("GRID_SOUNDING", false);
    public static final DataCategory TRACK_SOUNDING_CATEGORY = new DataCategory("TRACK_SOUNDING", false);
    public static final DataCategory TRAJECTORY_SOUNDING_CATEGORY = new DataCategory("TRAJECTORY_SOUNDING", false);
    public static final DataCategory XGRF_CATEGORY = new DataCategory("xgrf", false);
    public static final DataCategory LOCATIONS_CATEGORY = new DataCategory("locations", false);
    public static final DataCategory POINT_PLOT_CATEGORY = new DataCategory("PointPlot", false);
    private int categoryIndex = -1;
    private int childIndex = -1;
    private String append;
    private String replace;
    private boolean forDisplay = true;
    public static final String TAG_CATEGORIES = "categories";
    public static final String TAG_CATEGORY = "category";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESC = "desc";
    private static Hashtable allCategoriesMap;
    private static List allCategories;
    private static List currentCategories;
    private static Hashtable currentCategoriesMap;

    public DataCategory() {
        this("");
    }

    public DataCategory(boolean forDisplay) {
        this("", forDisplay);
    }

    public DataCategory(String name) {
        this(name, true);
    }

    public DataCategory(String name, boolean forDisplay) {
        this.name = name;
        this.forDisplay = forDisplay;
    }

    public DataCategory(String name, List metaCategories) {
        this.name = name;
        this.metaCategories = metaCategories;
    }

    public DataCategory(String name, DataCategory metaCategory) {
        this(name, Misc.newList(metaCategory));
    }

    public DataCategory(DataCategory parent, String name) {
        this.name = name;
        parent.setChild(this);
    }

    public boolean hasCategory() {
        return this.metaCategories != null;
    }

    public List getMetaCategories() {
        return this.metaCategories;
    }

    private static void processCategories(Element root) {
        List children = XmlUtil.findChildren(root, TAG_CATEGORY);
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String name = XmlUtil.getAttribute(child, ATTR_NAME);
            String value = XmlUtil.getAttribute(child, ATTR_DESC);
            if (allCategoriesMap.get(name) != null) continue;
            allCategories.add(name);
            allCategoriesMap.put(name, value);
        }
    }

    public static void init(XmlResourceCollection resources) {
        if (allCategoriesMap == null) {
            allCategoriesMap = new Hashtable();
            allCategories = new ArrayList();
        }
        for (int i = 0; i < resources.size(); ++i) {
            Element root = resources.getRoot(i);
            if (root == null) continue;
            DataCategory.processCategories(root);
        }
    }

    public static void addCurrentCategory(String c) {
        if (currentCategoriesMap.get(c) == null) {
            currentCategoriesMap.put(c, c);
            if (!c.startsWith("display:") && c.indexOf(";") < 0 && !c.startsWith("param:")) {
                currentCategories.add(c);
            }
        }
    }

    public static List getCurrentCategories() {
        return currentCategories;
    }

    public static DataCategory parseCategory(String c, boolean forDisplay) {
        if (!forDisplay) {
            DataCategory.addCurrentCategory(c);
        }
        StringTokenizer tok = new StringTokenizer(c, DIVIDER);
        DataCategory top = null;
        DataCategory current = null;
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken().trim();
            if (name.length() == 0) continue;
            if (top == null) {
                top = current = new DataCategory(name, forDisplay);
                continue;
            }
            current = new DataCategory(current, name);
        }
        return top;
    }

    public static List parseCategories(String c) {
        return DataCategory.parseCategories(c, true);
    }

    public static List parseCategories(String c, boolean firstOneForDisplay) {
        if (c == null) {
            return new ArrayList();
        }
        StringTokenizer tok = new StringTokenizer(c, ";");
        ArrayList<DataCategory> categories = new ArrayList<DataCategory>();
        int cnt = 0;
        String path = null;
        while (tok.hasMoreTokens()) {
            path = tok.nextToken().trim();
            DataCategory dataCategory = DataCategory.parseCategory(path, ++cnt == 1 && firstOneForDisplay);
            if (dataCategory == null) continue;
            categories.add(dataCategory);
        }
        if (cnt == 1 && firstOneForDisplay) {
            DataCategory.addCurrentCategory(path);
        }
        return categories;
    }

    public static DataCategory createCategory(String[] names) {
        DataCategory top = null;
        DataCategory current = null;
        for (int i = 0; i < names.length && names[i] != null; ++i) {
            if (top == null) {
                top = current = new DataCategory(names[i]);
                continue;
            }
            current = new DataCategory(current, names[i]);
        }
        return top;
    }

    public static DataCategory createCategory(String n1) {
        return DataCategory.createCategory(new String[]{n1});
    }

    public static DataCategory createCategory(String n1, String n2) {
        return DataCategory.createCategory(new String[]{n1, n2});
    }

    public static DataCategory createCategory(String n1, String n2, String n3) {
        return DataCategory.createCategory(new String[]{n1, n2, n3});
    }

    public static DataCategory createCategory(String n1, String n2, String n3, String n4) {
        return DataCategory.createCategory(new String[]{n1, n2, n3, n4});
    }

    public DataCategory getChild() {
        return this.child;
    }

    public void setChild(DataCategory child) {
        this.child = child;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public boolean isInherited() {
        return this.name.equals("inherit");
    }

    public String getFullName() {
        return this.getFullName(DIVIDER);
    }

    public String getFullName(String divider) {
        return this.name + (this.child == null ? "" : divider + this.child.getFullName(divider));
    }

    public String getFullName(String prefix, String suffix) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        sb.append(this.name);
        sb.append(suffix);
        if (this.child != null) {
            sb.append(this.child.getFullName(prefix, suffix));
        }
        return sb.toString();
    }

    protected String getPattern() {
        if (this.myPattern == null) {
            String myPart = "";
            myPart = this.name.equals(CATEGORY_ANY) ? "(-[^-]-)*" : (this.name.equals("+") ? "(-[^-]-)+" : (this.name.equals(".") ? "-[^-]+-" : DIVIDER + this.name + DIVIDER));
            if (this.child == null) {
                this.myPattern = myPart;
            } else {
                this.myPattern = myPart + this.child.getPattern();
                return this.myPattern;
            }
        }
        return this.myPattern;
    }

    public String toString() {
        return this.toString(DIVIDER);
    }

    public String toString(String divider) {
        if (this.child == null) {
            return this.name;
        }
        return this.name + divider + this.child.toString(divider);
    }

    public boolean applicableTo(List dcs) {
        int cnt = 0;
        for (int i = 0; i < dcs.size(); ++i) {
            DataCategory dc = (DataCategory)dcs.get(i);
            if (dc.getForDisplay()) continue;
            ++cnt;
            if (!this.applicableTo(dc)) continue;
            return true;
        }
        return cnt == 0;
    }

    public boolean applicableTo(DataCategory d) {
        String myPattern = this.getPattern();
        String input = d.getFullName(DIVIDER, DIVIDER);
        if (input.equals("-*-")) {
            return true;
        }
        try {
            boolean results = StringUtil.stringMatch(input, myPattern);
            return results;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("DataCategory error:" + exc);
        }
    }

    public void setForDisplay(boolean value) {
        this.forDisplay = value;
    }

    public boolean getForDisplay() {
        return this.forDisplay;
    }

    public static boolean applicableTo(List from, List to) {
        for (int i = 0; i < from.size(); ++i) {
            DataCategory category = (DataCategory)from.get(i);
            if (!category.applicableTo(to)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof DataCategory) {
            return this.getFullName().equals(((DataCategory)o).getFullName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        DataCategory test = DataCategory.parseCategory(args[0], false);
        for (int i = 1; i < args.length; ++i) {
            DataCategory dc = DataCategory.parseCategory(args[i], false);
            System.err.println("Pattern:" + dc.getPattern() + " match:" + dc.applicableTo(test));
        }
    }

    public static boolean matchRegexp(String source, String pattern) {
        return StringUtil.stringMatch(source, pattern);
    }

    public void setCategoryIndex(int value) {
        this.categoryIndex = value;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public void setChildIndex(int value) {
        this.childIndex = value;
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public void setAppend(String value) {
        this.append = value;
    }

    public String getAppend() {
        return this.append;
    }

    public void setReplace(String value) {
        this.replace = value;
    }

    public String getReplace() {
        return this.replace;
    }

    public DataCategory copyAndAppend(String append) {
        String newName = this.toString();
        if (append != null) {
            newName = newName + DIVIDER + append;
        }
        return DataCategory.parseCategory(newName, this.getForDisplay());
    }

    static {
        currentCategories = new ArrayList();
        currentCategoriesMap = new Hashtable();
    }
}

