/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.grid.GribVariableRenamer;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class DataAlias
implements Comparable {
    public static final String TAG_ALIAS = "alias";
    public static final String TAG_ALIASES = "aliases";
    public static final String ATTR_ALIASES = "aliases";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_LABEL = "label";
    private String name;
    private String label;
    private List aliases = new ArrayList();
    private GribVariableRenamer renamer = new GribVariableRenamer();
    private static List dataAliasList;
    private static List regExpAliases;
    private static List regExpObjects;
    private static List labelIdList;
    private static Hashtable canonicalToObject;
    private static Hashtable aliasToObject;

    public DataAlias(String name, String label) {
        this(name, label, null);
    }

    private DataAlias(String name, String label, List newAliases) {
        this.name = name;
        this.label = label;
        this.addAliases(newAliases);
    }

    protected void addAlias(String alias) {
        if (alias == null) {
            return;
        }
        if (StringUtil.containsRegExp(alias)) {
            regExpAliases.add(alias);
            regExpObjects.add(this);
        }
        if (!this.aliases.contains(alias)) {
            this.aliases.add(alias);
            aliasToObject.put(alias, this);
        }
    }

    protected void addAliases(List l) {
        if (l == null) {
            return;
        }
        for (int j = 0; j < l.size(); ++j) {
            this.addAlias((String)l.get(j));
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataAlias)) {
            return false;
        }
        return this.name.equals(((DataAlias)o).getName());
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public String getLabel() {
        return this.label;
    }

    public List getAliases() {
        return this.aliases;
    }

    public static List createDataAliases(Element root) {
        ArrayList<DataAlias> aliases = new ArrayList<DataAlias>();
        if (root == null) {
            return aliases;
        }
        List children = XmlUtil.findChildren(root, TAG_ALIAS);
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String canonical = XmlUtil.getAttribute(child, ATTR_NAME);
            String label = XmlUtil.getAttribute((Node)child, ATTR_LABEL, canonical);
            List<String> aliasList = StringUtil.split(XmlUtil.getAttribute(child, "aliases"));
            aliases.add(new DataAlias(canonical, label, aliasList));
        }
        return aliases;
    }

    public int compareTo(Object o) {
        if (!(o instanceof DataAlias)) {
            return 0;
        }
        DataAlias that = (DataAlias)o;
        return this.name.compareTo(that.name);
    }

    private static void readAliases(Element root) {
        GribVariableRenamer renamer = new GribVariableRenamer();
        List children = XmlUtil.findChildren(root, TAG_ALIAS);
        for (int i = 0; i < children.size(); ++i) {
            DataAlias dataAlias;
            Element child = (Element)children.get(i);
            String canonical = XmlUtil.getAttribute(child, ATTR_NAME);
            String label = XmlUtil.getAttribute((Node)child, ATTR_LABEL, canonical);
            List<String> aliasList = StringUtil.split(XmlUtil.getAttribute(child, "aliases"));
            if (Boolean.FALSE.booleanValue()) {
                for (int s = 0; s < aliasList.size(); ++s) {
                    List<String> newNames1 = renamer.matchNcepNames("grib1", aliasList.get(s).toString());
                    List<String> newNames2 = renamer.matchNcepNames("grib2", aliasList.get(s).toString());
                    List<String> newNames3 = renamer.getMappedNamesGrib1(aliasList.get(s).toString());
                    List<String> newNames4 = renamer.getMappedNamesGrib2(aliasList.get(s).toString());
                    ArrayList<String> newNames = new ArrayList<String>();
                    newNames.addAll(newNames1);
                    newNames.addAll(newNames2);
                    if (newNames3 != null) {
                        newNames.addAll(newNames3);
                    }
                    if (newNames4 != null) {
                        newNames.addAll(newNames4);
                    }
                    if (newNames.size() == 0) continue;
                    for (String newName : newNames) {
                        if (aliasList.contains(newName)) continue;
                        System.out.println(newName);
                        aliasList.add(newName);
                    }
                }
            }
            if ((dataAlias = (DataAlias)canonicalToObject.get(canonical)) == null) {
                dataAlias = new DataAlias(canonical, label);
                canonicalToObject.put(canonical, dataAlias);
                dataAliasList.add(dataAlias);
                labelIdList.add(new TwoFacedObject((Object)(label + " (" + canonical + ")"), canonical));
            }
            dataAlias.addAliases(aliasList);
        }
    }

    public static void reInit(XmlResourceCollection resources) {
        DataAlias.makeStructures(true);
        DataAlias.init(resources);
    }

    private static void makeStructures(boolean force) {
        if (!force && canonicalToObject != null) {
            return;
        }
        canonicalToObject = new Hashtable();
        aliasToObject = new Hashtable();
        dataAliasList = new ArrayList();
        labelIdList = new ArrayList();
        regExpObjects = new ArrayList();
        regExpAliases = new ArrayList();
    }

    public static void init(XmlResourceCollection resources) {
        DataAlias.makeStructures(false);
        for (int i = 0; i < resources.size(); ++i) {
            Element root = resources.getRoot(i, false);
            if (root == null) continue;
            DataAlias.readAliases(root);
        }
    }

    public static List getDataAliasList() {
        DataAlias.makeStructures(false);
        return new ArrayList(dataAliasList);
    }

    public static List getLabelIdList() {
        DataAlias.makeStructures(false);
        return new ArrayList(labelIdList);
    }

    public static String aliasToCanonical(String paramName) {
        if (paramName == null) {
            return null;
        }
        DataAlias.makeStructures(false);
        DataAlias dataAlias = (DataAlias)aliasToObject.get(paramName);
        if (dataAlias == null && (dataAlias = (DataAlias)StringUtil.findMatch(paramName, regExpAliases, regExpObjects, null)) != null) {
            aliasToObject.put(paramName, dataAlias);
        }
        if (dataAlias != null) {
            if (dataAlias.aliases.contains("!" + paramName)) {
                return null;
            }
            return dataAlias.getName();
        }
        return null;
    }

    public static List getAliasesOf(String paramName) {
        if (paramName == null) {
            return null;
        }
        DataAlias.makeStructures(false);
        DataAlias dataAlias = (DataAlias)canonicalToObject.get(paramName);
        if (dataAlias == null) {
            return null;
        }
        return dataAlias.getAliases();
    }

    public static DataAlias findAlias(String paramName) {
        if (paramName == null) {
            return null;
        }
        DataAlias.makeStructures(false);
        return (DataAlias)aliasToObject.get(paramName);
    }

    public String toString() {
        return "Name=" + this.name + " aliases=" + this.aliases;
    }
}

