/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.util.Misc;

public class CompositeDataChoice
extends DirectDataChoice {
    private boolean useDataSourceToFindTimes = false;
    List dataChoices;

    public CompositeDataChoice() {
        this.dataChoices = new ArrayList();
    }

    public CompositeDataChoice(CompositeDataChoice other) {
        super(other);
        this.dataChoices = CompositeDataChoice.cloneDataChoices(other.dataChoices);
        this.useDataSourceToFindTimes = other.useDataSourceToFindTimes;
    }

    public CompositeDataChoice(DataSource dataSource, Object id, String description, List categories) {
        this(dataSource, id, id.toString(), description, categories);
    }

    public CompositeDataChoice(DataSource dataSource, Object id, String name, String description, List categories) {
        this(dataSource, id, name, description, categories, (Hashtable)null);
    }

    public CompositeDataChoice(DataSource dataSource, Object id, String name, String description, List categories, Hashtable properties) {
        super(dataSource, id, name, description, categories, properties);
        this.dataChoices = new ArrayList();
    }

    public void expandIfNeeded() {
        this.dataSource.expandIfNeeded(this);
    }

    @Override
    public DataChoice cloneMe() {
        return new CompositeDataChoice(this);
    }

    @Override
    public void initAfterUnPersistence(Hashtable properties) {
        super.initAfterUnPersistence(properties);
        for (int i = 0; i < this.dataChoices.size(); ++i) {
            ((DataChoice)this.dataChoices.get(i)).initAfterUnPersistence(properties);
        }
    }

    @Override
    public void getFinalDataChoices(List finalDataChoices) {
        super.getFinalDataChoices(finalDataChoices);
        for (int i = 0; i < this.dataChoices.size(); ++i) {
            ((DataChoice)this.dataChoices.get(i)).getFinalDataChoices(finalDataChoices);
        }
    }

    public int getNumChildren() {
        return this.dataChoices.size();
    }

    @Override
    public List getAllLevels(DataSelection dataSelection) {
        Hashtable seen = new Hashtable();
        ArrayList mine = new ArrayList();
        dataSelection = DataSelection.merge(dataSelection, this.myDataSelection);
        for (int i = 0; i < this.dataChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.dataChoices.get(i);
            if (child == null) continue;
            Misc.addUnique(mine, child.getAllLevels(dataSelection), seen);
        }
        return mine;
    }

    @Override
    public List getAllDateTimes() {
        Hashtable seen = new Hashtable();
        ArrayList mine = new ArrayList();
        for (int i = 0; i < this.dataChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.dataChoices.get(i);
            if (child == null) continue;
            Misc.addUnique(mine, child.getAllDateTimes(), seen);
        }
        return mine;
    }

    @Override
    public List getSelectedDateTimes() {
        if (this.useDataSourceToFindTimes) {
            return this.dataSource.getSelectedDateTimes();
        }
        ArrayList mine = new ArrayList();
        Hashtable seen = new Hashtable();
        for (int i = 0; i < this.dataChoices.size(); ++i) {
            DataChoice child = (DataChoice)this.dataChoices.get(i);
            if (child == null) continue;
            Misc.addUnique(mine, child.getSelectedDateTimes(), seen);
        }
        return mine;
    }

    public void addDataChoice(DataChoice c) {
        this.dataChoices.add(c);
        c.setParent(this);
    }

    public void replaceDataChoice(DataChoice oldDataChoice, DataChoice newDataChoice) {
        int idx = this.dataChoices.indexOf(oldDataChoice);
        newDataChoice.setParent(this);
        oldDataChoice.setParent(null);
        if (idx >= 0) {
            this.dataChoices.set(idx, newDataChoice);
        } else {
            this.addDataChoice(newDataChoice);
        }
    }

    public void replaceDataChoices(List newChoices) {
        this.removeAllDataChoices();
        for (int i = 0; i < newChoices.size(); ++i) {
            this.addDataChoice((DataChoice)newChoices.get(i));
        }
    }

    public void removeAllDataChoices() {
        for (int i = 0; i < this.dataChoices.size(); ++i) {
            ((DataChoice)this.dataChoices.get(i)).setParent(null);
        }
        this.dataChoices = new ArrayList();
    }

    public void removeDataChoice(DataChoice c) {
        this.dataChoices.remove(c);
        c.setParent(null);
    }

    public List getDataChoices() {
        DataSource dataSource = this.getDataSource();
        this.dataChoices = dataSource.getCompositeDataChoices(this, this.dataChoices);
        return this.dataChoices;
    }

    public void setDataChoices(List l) {
        this.dataChoices = l;
    }

    public void setUseDataSourceToFindTimes(boolean value) {
        this.useDataSourceToFindTimes = value;
    }

    public boolean getUseDataSourceToFindTimes() {
        return this.useDataSourceToFindTimes;
    }
}

