/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import visad.Data;
import visad.VisADException;

public class CacheDataSource
extends DataSourceImpl {
    private Hashtable cache = new Hashtable();
    private String tmpDir;
    public static final String PROP_DATACHOICE = "CacheDataSource.DataChoice";
    public static final String PROP_DATA = "CacheDataSource.Data";
    private List holders = new ArrayList();
    private List currentChoices;

    public CacheDataSource() {
    }

    public CacheDataSource(DataSourceDescriptor descriptor, String name, Hashtable properties) {
        super(descriptor, "Cached data", "Cached data", properties);
    }

    @Override
    protected void addActions(List actions) {
        super.addActions(actions);
        AbstractAction a = null;
        a = new AbstractAction("Write to Serialized Format"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        Misc.run(CacheDataSource.this, "writeIser");
                    }
                });
            }
        };
        actions.add(a);
    }

    public void writeIser() {
        Window dialog = null;
        try {
            PatternFileFilter FILTER_ISER = new PatternFileFilter("(.+\\.iser$)", "Serialized Data File (*.iser)", ".iser");
            StringBuffer sb = new StringBuffer();
            String filename = FileManager.getWriteFile(Misc.newList(FILTER_ISER), "iser");
            if (filename == null) {
                return;
            }
            dialog = GuiUtils.createDialog(null, "Progress", false);
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            progressBar.setStringPainted(true);
            progressBar.setString("");
            JLabel label = new JLabel("Writing serialized data file                                                  ");
            ((JDialog)dialog).getContentPane().add(GuiUtils.inset((Component)GuiUtils.vbox(label, progressBar), 5));
            dialog.pack();
            dialog.setLocation(200, 200);
            ((Dialog)dialog).setVisible(true);
            ArrayList<DataChoiceHolder> holders = this.writeToCache(progressBar);
            if (holders.size() == 0) {
                LogUtil.userErrorMessage("None of the cached data has a serialized form");
                dialog.dispose();
                return;
            }
            progressBar.setString(" ");
            if (holders.size() > 1) {
                ArrayList<JCheckBox> cbxs = new ArrayList<JCheckBox>();
                for (int i = 0; i < holders.size(); ++i) {
                    DataChoiceHolder holder = (DataChoiceHolder)holders.get(i);
                    cbxs.add(new JCheckBox(holder.getName(), true));
                }
                JPanel contents = GuiUtils.vbox(new JLabel("What fields should be serialized?"), GuiUtils.vbox(cbxs));
                if (!GuiUtils.askOkCancel("Serialized Data", contents)) {
                    dialog.dispose();
                    return;
                }
                ArrayList<DataChoiceHolder> goodHolders = new ArrayList<DataChoiceHolder>();
                for (int i = 0; i < holders.size(); ++i) {
                    DataChoiceHolder holder = (DataChoiceHolder)holders.get(i);
                    if (!((JCheckBox)cbxs.get(i)).isSelected()) continue;
                    goodHolders.add(holder);
                }
                holders = goodHolders;
            }
            if (holders.size() == 0) {
                LogUtil.userErrorMessage("No fields selected. Not writing file.");
                dialog.dispose();
                return;
            }
            Document doc = XmlUtil.getDocument("<serializeddata></serializeddata>");
            Element root = doc.getDocumentElement();
            long total = 0L;
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(filename));
            for (int i = 0; i < holders.size(); ++i) {
                DataChoiceHolder holder = (DataChoiceHolder)holders.get(i);
                progressBar.setString("Writing:  " + holder.getName());
                File f = this.getCachedDataFile(holder.getId());
                String tail = IOUtil.getFileTail(f.toString());
                zos.putNextEntry(new ZipEntry(tail));
                progressBar.setString("Wrote " + (total += IOUtil.writeTo(new FileInputStream(f), zos, null, 0L)) + " bytes");
                DataChoice dataChoice = holder.getDataChoice();
                List categories = dataChoice.getCategories();
                String catstring = StringUtil.join(";", categories);
                Element dataElement = doc.createElement("data");
                root.appendChild(dataElement);
                dataElement.setAttribute("file", tail);
                dataElement.setAttribute("name", holder.getName());
                dataElement.setAttribute("categories", catstring);
                String icon = (String)dataChoice.getProperty("prop.icon");
                if (icon == null) continue;
                dataElement.setAttribute("icon", icon);
            }
            byte[] xmlbytes = XmlUtil.toString(root).getBytes();
            zos.putNextEntry(new ZipEntry("data.xser"));
            zos.write(xmlbytes, 0, xmlbytes.length);
            zos.close();
            dialog.dispose();
            JLabel question = new JLabel("<html>The file:<br><i>" + filename + "</i><br>has been written.<p>&nbsp;<br>" + "<b>Note: the data held in this serialized format is not guaranteed to work with future versions of the IDV.</b><p><hr><p>" + "Do you want to load the data into the IDV now?</html>");
            if (GuiUtils.askYesNo("Serialized Data File", question)) {
                this.getDataContext().getIdv().handleAction(filename, null);
            }
        }
        catch (Exception iexc) {
            if (dialog != null) {
                dialog.dispose();
            }
            LogUtil.logException("There was an error writing the serialized data", iexc);
        }
    }

    public void addDataChoice(DataChoice dataChoice, String name, Data data) {
        this.addDataChoice(dataChoice, name, data, null);
    }

    public void addDataChoice(DataChoice dataChoice, String name, Data data, DataSelection dataSelection) {
        this.currentChoices = null;
        DataChoiceHolder holder = new DataChoiceHolder(dataChoice, name, dataSelection);
        this.holders.add(holder);
        if (data != null) {
            this.putCache(holder.getId(), data);
        }
        this.getDataContext().dataSourceChanged(this);
    }

    private Object getCacheKey(DataChoiceHolder holder) {
        return holder.getId();
    }

    private File getCachedDataFile(Object id) {
        if (this.tmpDir == null) {
            return null;
        }
        return new File(IOUtil.joinDir(this.tmpDir, id.toString()) + ".ser");
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.writeToCache(null);
        this.cache = new Hashtable();
    }

    private List writeToCache(JProgressBar progressBar) {
        if (this.tmpDir == null) {
            this.tmpDir = IOUtil.joinDir(this.getDataContext().getIdv().getStore().getUserTmpDirectory(), "datacache_" + Misc.getUniqueId());
            IOUtil.makeDir(this.tmpDir);
        }
        Hashtable cachedKeys = new Hashtable();
        Enumeration keys = this.cache.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = this.cache.get(key);
            File f = this.getCachedDataFile(key);
            if (f.exists()) {
                cachedKeys.put(key, key);
                continue;
            }
            try {
                byte[] bytes;
                DataChoiceHolder holder = this.findHolder(key);
                if (progressBar != null) {
                    progressBar.setString("Serializing data:" + holder.getName());
                }
                if ((bytes = Misc.serialize((Serializable)value)) == null) continue;
                IOUtil.writeBytes(f, bytes);
                cachedKeys.put(key, key);
            }
            catch (Exception exc) {
                System.err.println("Error:" + exc);
            }
        }
        ArrayList<DataChoiceHolder> goodHolders = new ArrayList<DataChoiceHolder>();
        for (int holderIdx = 0; holderIdx < this.holders.size(); ++holderIdx) {
            DataChoiceHolder holder = (DataChoiceHolder)this.holders.get(holderIdx);
            if (cachedKeys.get(holder.getId()) == null) continue;
            goodHolders.add(holder);
        }
        return goodHolders;
    }

    private DataChoiceHolder findHolder(Object key) {
        for (int holderIdx = 0; holderIdx < this.holders.size(); ++holderIdx) {
            DataChoiceHolder holder = (DataChoiceHolder)this.holders.get(holderIdx);
            if (!holder.getId().equals(key)) continue;
            return holder;
        }
        return null;
    }

    @Override
    public void putCache(Object key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public Object getCache(Object key) {
        return this.cache.get(key);
    }

    @Override
    public void removeCache(Object key) {
        this.cache.remove(key);
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        File f;
        Object id = dataChoice.getId();
        DataChoiceHolder holder = null;
        for (int holderIdx = 0; holderIdx < this.holders.size(); ++holderIdx) {
            DataChoiceHolder tmpHolder = (DataChoiceHolder)this.holders.get(holderIdx);
            if (!tmpHolder.getId().equals(dataChoice.getId())) continue;
            holder = tmpHolder;
            break;
        }
        if (holder == null) {
            return null;
        }
        DataChoice theDataChoice = holder.getDataChoice();
        Hashtable newRequestProperties = DataChoice.mergeRequestProperties(requestProperties, theDataChoice.getFixedRequestProperties());
        Object cacheKey = holder.getId();
        Data data = (Data)this.getCache(cacheKey);
        if (data == null && (f = this.getCachedDataFile(cacheKey)) != null && f.exists()) {
            try {
                data = (Data)Misc.deserialize(IOUtil.readBytes(IOUtil.getInputStream(f.toString(), this.getClass())));
            }
            catch (Exception exc) {
                System.err.println("Error reading cached data:" + exc);
            }
        }
        if (data == null) {
            data = theDataChoice.getData(holder.getDataSelection(), requestProperties);
            this.putCache(cacheKey, data);
        }
        return data;
    }

    @Override
    public List getDataChoices() {
        if (this.currentChoices == null) {
            this.currentChoices = new ArrayList();
            for (int holderIdx = 0; holderIdx < this.holders.size(); ++holderIdx) {
                DataChoiceHolder holder = (DataChoiceHolder)this.holders.get(holderIdx);
                DataChoice dataChoice = holder.getDataChoice();
                ArrayList<DataCategory> categories = new ArrayList<DataCategory>();
                List tmpCategories = dataChoice.getCategories();
                if (tmpCategories != null) {
                    for (int catIdx = 0; catIdx < tmpCategories.size(); ++catIdx) {
                        DataCategory dc = (DataCategory)tmpCategories.get(catIdx);
                        if (dc.getForDisplay()) continue;
                        categories.add(dc);
                    }
                }
                Hashtable properties = null;
                if (dataChoice.getProperties() != null) {
                    properties = new Hashtable(dataChoice.getProperties());
                }
                DirectDataChoice choice = new DirectDataChoice((DataSource)this, holder.getId(), holder.getName(), holder.getName(), categories, properties);
                choice.setFixedRequestProperties(dataChoice.getFixedRequestProperties());
                this.currentChoices.add(choice);
            }
        }
        return this.currentChoices;
    }

    public void setHolders(List value) {
        this.holders = value;
    }

    public List getHolders() {
        return this.holders;
    }

    public static class DataChoiceHolder {
        Object id;
        DataChoice dataChoice;
        String name;
        DataSelection dataSelection;

        public DataChoiceHolder() {
        }

        public DataChoiceHolder(DataChoice dataChoice, String name, DataSelection dataSelection) {
            this.id = Misc.getUniqueId();
            this.dataChoice = dataChoice;
            this.name = name;
            this.dataSelection = dataSelection;
        }

        public void setId(Object value) {
            this.id = value;
        }

        public Object getId() {
            return this.id;
        }

        public void setDataChoice(DataChoice value) {
            this.dataChoice = value;
        }

        public DataChoice getDataChoice() {
            return this.dataChoice;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getName() {
            return this.name;
        }

        public void setDataSelection(DataSelection value) {
            this.dataSelection = value;
        }

        public DataSelection getDataSelection() {
            return this.dataSelection;
        }
    }
}

