/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataUtil;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.UtcDate;
import ucar.visad.data.CalendarDateTime;
import visad.DateTime;
import visad.VisADException;

public final class AddeUtil {
    public static final String RELATIVE_TIME = "%relative%";
    public static final String TIME_DRIVER_TIMES = "%timedriver%";
    public static final String RELATIVE_TIME_RANGE = "%relative_range%";
    public static final String LATLON_BOX = "%latlonbox%";
    public static final String LEVEL = "%level%";
    public static String NUM_RELATIVE_TIMES = "number of relative times";
    public static String RELATIVE_TIME_INCREMENT = "relative time increment";
    public static String ABSOLUTE_TIMES = "absolute_times";
    public static final String MISC_KEYWORDS = "misckeywords";

    public static List<String> generateTimeUrls(DataSourceImpl datasource, String url, DataSelection subset) {
        ArrayList<DateTime> allTimes;
        int[] timeIndices;
        ArrayList<String> urls = new ArrayList<String>();
        List<DateTime> driverTimes = null;
        List subTimes = null;
        ArrayList<DateTime> absTimes = null;
        Object tmp = datasource.getProperty(NUM_RELATIVE_TIMES, new Integer(0));
        if (tmp instanceof Integer) {
            int numTimes = (Integer)tmp;
            timeIndices = new int[numTimes];
            for (int i = 0; i < numTimes; ++i) {
                timeIndices[i] = i;
            }
        } else {
            timeIndices = (int[])tmp;
        }
        if (subset != null) {
            driverTimes = subset.getTimeDriverTimes();
            subTimes = subset.getTimes();
        }
        if (driverTimes == null && (allTimes = datasource.getAllDateTimes()) != null && !allTimes.isEmpty()) {
            Object timeObj = allTimes.get(0);
            if (subTimes != null && !subTimes.isEmpty()) {
                int i;
                timeIndices = new int[subTimes.size()];
                for (i = 0; i < subTimes.size(); ++i) {
                    timeIndices[i] = (Integer)subTimes.get(i);
                }
                if (timeObj instanceof DateTime) {
                    absTimes = new ArrayList<DateTime>();
                    for (i = 0; i < timeIndices.length; ++i) {
                        absTimes.add((DateTime)allTimes.get(timeIndices[i]));
                    }
                }
            } else if (timeObj instanceof DateTime) {
                absTimes = allTimes;
            }
        }
        Hashtable htable = datasource.getProperties();
        String checkglm = "";
        if (htable != null) {
            checkglm = (String)datasource.getProperties().get("data name");
        }
        if (driverTimes != null) {
            if (checkglm.contains("GLM Lightning Data")) {
                urls.addAll(AddeUtil.makeGLMDriverTimesUrls(url, datasource, driverTimes));
            } else {
                urls.addAll(AddeUtil.makeDriverTimesUrls(url, datasource, driverTimes));
            }
        } else if (absTimes != null) {
            if (checkglm.contains("GLM Lightning Data")) {
                float timeInc = ((Number)datasource.getProperty(RELATIVE_TIME_INCREMENT, new Float(1.0f))).floatValue();
                urls.addAll(AddeUtil.makeAbsoluteTimesUrlsGLM(url, datasource, (List<DateTime>)absTimes, timeInc));
            } else {
                urls.addAll(AddeUtil.makeAbsoluteTimesUrls(url, datasource, (List<DateTime>)absTimes));
            }
        } else if (url.indexOf(RELATIVE_TIME) >= 0) {
            if (checkglm.contains("GLM Lightning Data")) {
                float timeInc = ((Number)datasource.getProperty(RELATIVE_TIME_INCREMENT, new Float(1.0f))).floatValue();
                url = url.replaceAll("MAX=99999", "MAX=999999");
                url = url.replaceAll("POS=1", "POS=ALL");
                String[] times = AddeUtil.makeRelativeTimesGLM(timeIndices, timeInc);
                for (int i = 0; i < times.length; ++i) {
                    String newUrl = url.replaceAll(RELATIVE_TIME, times[i]);
                    urls.add(newUrl);
                }
            } else {
                float timeInc = ((Number)datasource.getProperty(RELATIVE_TIME_INCREMENT, new Float(1.0f))).floatValue();
                String[] times = AddeUtil.makeRelativeTimes(timeIndices, timeInc);
                for (int i = 0; i < times.length; ++i) {
                    String newUrl = url.replaceAll(RELATIVE_TIME, times[i]);
                    urls.add(newUrl);
                }
            }
        } else {
            urls.add(url);
        }
        return urls;
    }

    private static List<String> makeAbsoluteTimesUrls(String url, DataSourceImpl datasource, List<DateTime> absTimes) {
        ArrayList<String> urls = new ArrayList<String>();
        if (absTimes == null || absTimes.isEmpty()) {
            urls.add(url);
        }
        Collections.sort(absTimes);
        String day = null;
        String time = null;
        StringBuilder hours = new StringBuilder();
        for (DateTime dt : absTimes) {
            String newTime;
            String date = UtcDate.getIYD(dt);
            if (day == null) {
                day = date;
            } else if (!Misc.equals(day, date)) {
                String dayTime = AddeUtil.makeDateUrl(day, hours.toString());
                urls.add(AddeUtil.replaceDateTime(url, dayTime));
                day = date;
                hours = new StringBuilder();
            }
            if (Misc.equals(newTime = UtcDate.getHMS(dt), time)) continue;
            hours.append(UtcDate.getHMS(dt));
            hours.append(",");
            time = newTime;
        }
        String dayTime = AddeUtil.makeDateUrl(day, hours.toString());
        urls.add(AddeUtil.replaceDateTime(url, dayTime));
        return urls;
    }

    private static List<String> makeAbsoluteTimesUrlsGLM(String url, DataSourceImpl datasource, List<DateTime> absTimes, float timInc) {
        ArrayList<String> urls = new ArrayList<String>();
        if (absTimes == null || absTimes.isEmpty()) {
            urls.add(url);
        }
        timInc *= 60.0f;
        Collections.sort(absTimes);
        GregorianCalendar utcCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        url = url.replaceAll("MAX=99999", "MAX=999999");
        url = url.replaceAll("POS=1", "POS=ALL");
        for (DateTime dt : absTimes) {
            try {
                CalendarDateTime cdt = new CalendarDateTime(dt);
                utcCalendar.setTime(cdt.getCalendarDate().toDate());
            }
            catch (Exception cdt) {
                // empty catch block
            }
            int newMin = utcCalendar.get(12);
            int newHour = utcCalendar.get(11);
            int newDay = utcCalendar.get(6);
            int newYear = utcCalendar.get(1);
            String thisDate = "" + newYear + StringUtil.padZero(newDay, 3);
            utcCalendar.add(12, -((int)timInc));
            int newMin0 = utcCalendar.get(12);
            int newHour0 = utcCalendar.get(11);
            int newDay0 = utcCalendar.get(6);
            int newYear0 = utcCalendar.get(1);
            String thisDate0 = "" + newYear0 + StringUtil.padZero(newDay0, 3);
            String times = "";
            times = times + newHour0 + StringUtil.padZero(newMin0, 2) + "00" + " " + newHour + StringUtil.padZero(newMin, 2) + "00";
            LogUtil.consoleMessage(times);
            String daytime = AddeUtil.makeDateUrl(thisDate0, thisDate, times);
            urls.add(AddeUtil.replaceDateTime(url, daytime));
        }
        return urls;
    }

    private static String replaceDateTime(String url, String newTime) {
        url = url.indexOf(RELATIVE_TIME) >= 0 ? url.replaceAll(RELATIVE_TIME, newTime) : url.replaceAll("time [^;]*;", newTime + ";");
        return url;
    }

    private static List<String> makeDriverTimesUrls(String url, DataSourceImpl datasource, List<DateTime> driverTimes) {
        ArrayList<String> urls = new ArrayList<String>();
        if (driverTimes == null || driverTimes.isEmpty()) {
            urls.add(url);
        }
        Collections.sort(driverTimes);
        Object day = null;
        Object time = null;
        SortedSet<String> uniqueDays = Collections.synchronizedSortedSet(new TreeSet());
        for (DateTime dt : driverTimes) {
            String theDay = UtcDate.getYMD(dt);
            uniqueDays.add(theDay);
        }
        float timeInc = ((Number)datasource.getProperty(RELATIVE_TIME_INCREMENT, new Float(1.0f))).floatValue();
        int numTimes = (int)(24.0f / timeInc);
        ArrayList<DateTime> alltimes = new ArrayList<DateTime>();
        for (String today : uniqueDays) {
            for (int i = 0; i < numTimes; ++i) {
                float hours = (float)i * timeInc;
                int hour = (int)hours;
                int minutes = (int)((hours - (float)hour) * 60.0f);
                String dateString = today + " " + StringUtil.padZero(hour, 2) + ":" + StringUtil.padZero(minutes, 2) + ":00";
                try {
                    DateTime dt = UtcDate.createDateTime(dateString, "yyyy-MM-dd HH:mm:ss");
                    alltimes.add(dt);
                    continue;
                }
                catch (VisADException ve) {
                    System.err.println("Unable to parse date string: " + dateString);
                }
            }
        }
        try {
            List<DateTime> matches = DataUtil.selectTimesFromList(alltimes, driverTimes);
            urls.addAll(AddeUtil.makeAbsoluteTimesUrls(url, datasource, matches));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    private static List<String> makeGLMDriverTimesUrls(String url, DataSourceImpl datasource, List<DateTime> driverTimes) {
        ArrayList<String> urls = new ArrayList<String>();
        if (driverTimes == null || driverTimes.isEmpty()) {
            urls.add(url);
        }
        Collections.sort(driverTimes);
        Object day = null;
        Object time = null;
        SortedSet<String> uniqueDays = Collections.synchronizedSortedSet(new TreeSet());
        for (DateTime dt : driverTimes) {
            String theDay = UtcDate.getYMD(dt);
            uniqueDays.add(theDay);
        }
        float timeInc = ((Number)datasource.getProperty(RELATIVE_TIME_INCREMENT, new Float(1.0f))).floatValue();
        int numTimes = (int)(24.0f / timeInc);
        ArrayList<DateTime> uniqueTimes = new ArrayList<DateTime>();
        try {
            GregorianCalendar utcCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            Date now = DateUtil.parse(driverTimes.get(driverTimes.size() - 1).toString());
            if (now == null) {
                now = new Date();
            }
            utcCalendar.setTime(now);
            int min = (int)(timeInc * 60.0f);
            int minB = 2;
            utcCalendar.add(12, -minB);
            int sec = utcCalendar.get(13);
            utcCalendar.add(13, -sec);
            try {
                DateTime dt = new DateTime(utcCalendar.getTime());
                uniqueTimes.add(dt);
            }
            catch (Exception dt) {
                // empty catch block
            }
            for (int i = 1; i < numTimes; ++i) {
                utcCalendar.add(12, -min);
                try {
                    DateTime dt = new DateTime(utcCalendar.getTime());
                    uniqueTimes.add(dt);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception utcCalendar) {
            // empty catch block
        }
        try {
            List<DateTime> matches = DataUtil.selectTimesFromList(uniqueTimes, driverTimes);
            urls.addAll(AddeUtil.makeAbsoluteTimesUrlsGLM(url, datasource, matches, timeInc));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    public static String[] makeRelativeTimes(int[] timeIndices, float timeInc) {
        GregorianCalendar utcCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        String currentDate = null;
        String times = null;
        ArrayList<String> timesList = new ArrayList<String>();
        Date now = new Date();
        int minInc = (int)(60.0f * timeInc);
        int minutes = minInc % 60;
        int hours = minInc / 60;
        utcCalendar.setTime(now);
        int curHour = utcCalendar.get(11);
        int curMin = utcCalendar.get(12);
        int hdiff = hours == 0 ? 0 : curHour % hours;
        int mdiff = minutes == 0 ? curMin : curMin % minutes;
        utcCalendar.add(11, -hdiff);
        utcCalendar.add(12, -mdiff);
        now = utcCalendar.getTime();
        for (int i = 0; i < timeIndices.length; ++i) {
            utcCalendar.setTime(now);
            utcCalendar.add(12, -timeIndices[i] * minInc);
            int newMin = utcCalendar.get(12);
            int newHour = utcCalendar.get(11);
            int newDay = utcCalendar.get(6);
            int newYear = utcCalendar.get(1);
            String thisDate = "" + newYear + StringUtil.padZero(newDay, 3);
            if (!Misc.equals(currentDate, thisDate)) {
                if (currentDate != null) {
                    timesList.add(AddeUtil.makeDateUrl(currentDate, times.toString()));
                }
                currentDate = thisDate;
                times = "";
            }
            if (times.length() > 0) {
                times = times + ",";
            }
            times = times + newHour + ":" + StringUtil.padZero(newMin, 2);
        }
        if (currentDate != null) {
            timesList.add(AddeUtil.makeDateUrl(currentDate, times));
        }
        return timesList.toArray(new String[timesList.size()]);
    }

    public static String[] makeRelativeTimesGLM(int[] timeIndices, float timeInc) {
        GregorianCalendar utcCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        Object currentDate = null;
        String times = null;
        ArrayList<String> timesList = new ArrayList<String>();
        Date now = new Date();
        int minInc = (int)(timeInc * 60.0f);
        int minutes = minInc % 60;
        int hours = minInc / 60;
        utcCalendar.setTime(now);
        int curHour = utcCalendar.get(11);
        int curMin = utcCalendar.get(12);
        int hdiff = hours == 0 ? 0 : curHour % hours;
        int mdiff = minutes == 0 ? curMin : curMin % minutes;
        utcCalendar.add(11, -hdiff);
        utcCalendar.add(12, -mdiff);
        for (int i = 0; i < timeIndices.length; ++i) {
            utcCalendar.add(12, -timeIndices[i] * minInc);
            int newMin = utcCalendar.get(12);
            int newHour = utcCalendar.get(11);
            int newDay = utcCalendar.get(6);
            int newYear = utcCalendar.get(1);
            String thisDate = "" + newYear + StringUtil.padZero(newDay, 3);
            utcCalendar.add(12, -minInc);
            int newMin0 = utcCalendar.get(12);
            int newHour0 = utcCalendar.get(11);
            int newDay0 = utcCalendar.get(6);
            int newYear0 = utcCalendar.get(1);
            String thisDate0 = "" + newYear0 + StringUtil.padZero(newDay0, 3);
            times = "";
            if (times.length() > 0) {
                times = times + ",";
            }
            times = times + newHour0 + StringUtil.padZero(newMin0, 2) + "00" + " " + newHour + StringUtil.padZero(newMin, 2) + "00";
            System.out.println(times);
            LogUtil.consoleMessage(times);
            timesList.add(AddeUtil.makeDateUrl(thisDate0, thisDate, times));
            utcCalendar.add(12, minInc + timeIndices[i] * minInc);
        }
        return timesList.toArray(new String[timesList.size()]);
    }

    private static String makeDateUrl(String day, String times) {
        StringBuffer sb = new StringBuffer();
        sb.append("DAY ");
        sb.append(day);
        sb.append(" ");
        sb.append(day);
        sb.append(";TIME ");
        sb.append(times);
        return sb.toString();
    }

    private static String makeDateUrl(String day, String day1, String times) {
        StringBuffer sb = new StringBuffer();
        sb.append("DAY ");
        sb.append(day);
        sb.append(" ");
        sb.append(day1);
        sb.append(";TIME ");
        sb.append(times);
        return sb.toString();
    }

    public static void main(String[] args) {
        int[] times = new int[]{0, 5, 8, 12, 16, 20};
        times = new int[]{0, 1, 2};
        AddeUtil.makeRelativeTimes(times, 12.0f);
        for (int i = 1; i < 6; ++i) {
            System.err.println("inc:" + i);
            AddeUtil.makeRelativeTimes(times, i);
        }
    }
}

