/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.collab;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.collab.Sharable;
import ucar.unidata.collab.SharableListener;
import ucar.unidata.util.LogUtil;

public class SharableManager {
    private static final Object MUTEX = new Object();
    private static final long SHARE_TIME_THRESHOLD = 1000L;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(SharableManager.class.getName());
    public static final LogUtil LU = null;
    private static List listeners;
    public static List shareGroupNames;
    private static boolean activelySharing;
    public static final String GROUP_ALL = "All";
    private static Hashtable groupToList;
    private static List shareGroups;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getShareGroupNames() {
        Object object = MUTEX;
        synchronized (object) {
            if (shareGroupNames == null) {
                SharableManager.initShareGroupNames();
            }
            return new ArrayList(shareGroupNames);
        }
    }

    public static void addShareGroupName(String name) {
        SharableManager.getShareGroupNames();
        if (!shareGroupNames.contains(name)) {
            shareGroupNames.add(0, name);
        }
    }

    private static void initShareGroupNames() {
        shareGroupNames = new ArrayList();
        shareGroupNames.add("Group 1");
        shareGroupNames.add("Group 2");
        shareGroupNames.add("Group 3");
        shareGroupNames.add("Group 4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getGroupList(Object group) {
        Object object = MUTEX;
        synchronized (object) {
            if (group == null) {
                return null;
            }
            ArrayList l = (ArrayList)groupToList.get(group);
            if (l == null) {
                l = new ArrayList();
                groupToList.put(group, l);
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSharable(Sharable s) {
        Object object = MUTEX;
        synchronized (object) {
            List groupList = SharableManager.getGroupList(s.getShareGroup());
            if (groupList == null) {
                return;
            }
            if (!groupList.contains(s)) {
                groupList.add(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSharable(Sharable s) {
        Object object = MUTEX;
        synchronized (object) {
            List groupList = SharableManager.getGroupList(s.getShareGroup());
            if (groupList == null) {
                return;
            }
            groupList.remove(s);
        }
    }

    public static void addSharableListener(SharableListener listener) {
        if (listeners == null) {
            listeners = new ArrayList();
        }
        listeners.add(listener);
    }

    public static void removeSharableListener(SharableListener listener) {
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }

    protected static void checkShareData(Sharable from, Object dataId, Object[] data, boolean internal, boolean external) {
        Long lastTime = from.getReceiveShareTime(dataId);
        if (lastTime != null && System.currentTimeMillis() - lastTime < 1000L) {
            return;
        }
        if (internal && from.getSharing()) {
            SharableManager.sendShareData(from, dataId, data);
        }
        if (external && from != null && listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                ((SharableListener)listeners.get(i)).checkShareData(from, dataId, data);
            }
        }
    }

    private static void sendShareData(Sharable from, Object dataId, Object[] data) {
        SharableManager.sendShareData(from, from.getShareGroup(), dataId, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendShareData(Sharable from, Object shareGroup, Object dataId, Object[] data) {
        Object object = MUTEX;
        synchronized (object) {
            if (activelySharing) {
                return;
            }
            activelySharing = true;
        }
        try {
            List groupList = SharableManager.getGroupList(shareGroup);
            if (groupList == null) {
                return;
            }
            for (int i = 0; i < groupList.size(); ++i) {
                Sharable to = (Sharable)groupList.get(i);
                if (to == from || !to.getSharing()) continue;
                to.setReceiveShareTime(dataId, new Long(System.currentTimeMillis()));
                to.receiveShareData(from, dataId, data);
            }
        }
        catch (Exception e) {
            LogUtil.printException(log_, "sendShareData:" + dataId, e);
        }
        activelySharing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDefaultShareGroups() {
        Object object = MUTEX;
        synchronized (object) {
            if (shareGroups == null) {
                shareGroups = new ArrayList();
                shareGroups.add(GROUP_ALL);
            }
            return shareGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShareGroup(Object group) {
        Object object = MUTEX;
        synchronized (object) {
            List groups = SharableManager.getDefaultShareGroups();
            groups.add(group);
        }
    }

    static {
        activelySharing = false;
        groupToList = new Hashtable();
        shareGroups = null;
    }
}

