/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.collab;

import java.awt.Component;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import ucar.unidata.collab.Sharable;
import ucar.unidata.collab.SharableManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public class SharableImpl
implements Sharable {
    private boolean sharing;
    private Object shareGroup;
    private String uniqueId;
    private boolean hasBeenInitialized = false;
    private JComboBox shareGroupBox;
    private Hashtable<Object, Long> lastReceiveShareTime;

    public SharableImpl() {
        this("All", false);
    }

    public SharableImpl(boolean sharing) {
        this("All", sharing);
    }

    public SharableImpl(Object group, boolean sharing) {
        this.sharing = sharing;
        this.shareGroup = group;
    }

    public void showSharableDialog() {
        JComponent contents = this.getSharablePropertiesComponent();
        if (!GuiUtils.showOkCancelDialog(null, "Sharable Properties", contents = GuiUtils.inset((Component)contents, 5), null)) {
            return;
        }
        this.applySharableProperties();
    }

    private void initGroupBox() {
        if (this.shareGroupBox == null) {
            this.shareGroupBox = new JComboBox();
            this.shareGroupBox.setEditable(true);
        }
        String myName = this.shareGroup.toString();
        List names = SharableManager.getShareGroupNames();
        if (!names.contains(myName)) {
            names.add(0, myName);
            SharableManager.addShareGroupName(myName);
        }
        GuiUtils.setListData(this.shareGroupBox, names);
        this.shareGroupBox.setSelectedItem(myName);
    }

    public JComponent getSharablePropertiesComponent() {
        this.initGroupBox();
        return GuiUtils.left(GuiUtils.label("Group: ", this.shareGroupBox));
    }

    public void applySharableProperties() {
        if (this.shareGroupBox == null) {
            return;
        }
        this.setShareGroup(this.shareGroupBox.getSelectedItem());
        SharableManager.addShareGroupName(this.shareGroupBox.getSelectedItem().toString());
        this.initGroupBox();
    }

    protected void initSharable() {
        if (this.hasBeenInitialized) {
            return;
        }
        this.hasBeenInitialized = true;
        SharableManager.addSharable(this);
    }

    @Override
    public boolean getSharing() {
        return this.sharing;
    }

    public void setSharing(boolean sharing) {
        this.sharing = sharing;
    }

    @Override
    public Object getShareGroup() {
        return this.shareGroup;
    }

    public void removeSharable() {
        SharableManager.removeSharable(this);
    }

    public void setShareGroup(Object shareGroup) {
        if (this.hasBeenInitialized) {
            SharableManager.removeSharable(this);
        }
        this.shareGroup = shareGroup;
        if (this.hasBeenInitialized) {
            SharableManager.addSharable(this);
        }
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
    }

    @Override
    public Long getReceiveShareTime(Object dataId) {
        if (this.lastReceiveShareTime == null) {
            return null;
        }
        return this.lastReceiveShareTime.get(dataId);
    }

    @Override
    public void setReceiveShareTime(Object dataId, Long time) {
        if (this.lastReceiveShareTime == null) {
            this.lastReceiveShareTime = new Hashtable();
        }
        this.lastReceiveShareTime.put(dataId, time);
    }

    private void doShare(Object dataId, Object[] data, boolean internal, boolean external) {
        SharableManager.checkShareData(this, dataId, data, internal, external);
    }

    public void doShare(Object dataId, Object[] data) {
        this.doShare(dataId, data, true, true);
    }

    public void doShare(Object dataId, Object data) {
        this.doShare(dataId, new Object[]{data});
    }

    public void doShareExternal(Object dataId, Object data) {
        this.doShare(dataId, new Object[]{data}, false, true);
    }

    public void doShareInternal(Object dataId, Object data) {
        this.doShare(dataId, new Object[]{data}, true, false);
    }

    @Override
    public String getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = "sharable_" + Misc.getUniqueId();
        }
        return this.uniqueId;
    }

    public void setUniqueId(String id) {
        this.uniqueId = id;
    }
}

