/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.collab;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.collab.Client;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class Server {
    public static int DEFAULT_PORT = 8080;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(Server.class.getName());
    private int port = DEFAULT_PORT;
    private ServerSocket serverSocket;
    private List clients = new ArrayList();
    private boolean isRunning = false;

    public Server() {
        this(DEFAULT_PORT);
    }

    public Server(int port) {
        this.port = port;
    }

    public void startServer(int newPort) throws IOException {
        this.port = newPort;
        if (this.isRunning) {
            return;
        }
        this.serverSocket = new ServerSocket(this.port);
        Misc.run(new Runnable(){

            @Override
            public void run() {
                Server.this.runServer();
            }
        });
    }

    public void startServer() throws IOException {
        this.startServer(this.port);
    }

    public void stopServer() {
        if (this.isRunning) {
            this.isRunning = false;
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void runServer() {
        this.isRunning = true;
        this.notifyServerStart();
        while (this.isRunning) {
            try {
                Socket socket = this.serverSocket.accept();
                if (!this.isRunning) break;
                this.initClient(socket);
            }
            catch (Exception e) {
                if (!this.isRunning) break;
                System.out.println("Server got an exception:" + e);
                break;
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        this.isRunning = false;
        this.notifyServerStop();
    }

    protected void notifyServerStart() {
    }

    protected void notifyServerStop() {
    }

    protected void notifyClientAdd(Client client) {
    }

    protected void notifyClientRemove(Client client) {
    }

    public boolean getIsRunning() {
        return this.isRunning;
    }

    protected Client createClient(Socket clientSocket) throws IOException {
        return new Client(clientSocket);
    }

    protected void initClient(Socket clientSocket) {
        Client client = null;
        try {
            client = this.createClient(clientSocket);
            this.addClient(client);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void runClient(Client client) {
        try {
            String message;
            while ((message = client.read()) != null) {
                if (!client.getOkToReceive()) continue;
                this.handleIncomingMessage(client, message);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (client != null) {
            this.removeClient(client);
        }
    }

    public List getClients() {
        return this.clients;
    }

    public boolean hasClients() {
        return this.clients.size() > 0;
    }

    public void addClient(Client client) {
        this.addClient(client, true);
    }

    public void addClient(final Client client, boolean andStartListening) {
        this.clients.add(client);
        this.notifyClientAdd(client);
        if (andStartListening) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    Server.this.runClient(client);
                }
            });
        }
    }

    public void removeClient(Client client) {
        try {
            client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clients.remove(client);
        this.notifyClientRemove(client);
    }

    protected void handleIncomingMessage(Client fromClient, String message) {
        if (fromClient.getValid()) {
            this.write(message, fromClient);
        }
    }

    public void write(String message) {
        this.write(message, null);
    }

    public void write(String message, Client exceptClient) {
        try {
            for (int i = 0; i < this.clients.size(); ++i) {
                Client client = (Client)this.clients.get(i);
                if (Misc.equals(exceptClient, client) || !client.getValid()) continue;
                client.write(message);
            }
        }
        catch (Exception ioe) {
            this.logException("Writing message:" + message, ioe);
        }
    }

    protected void logException(String msg, Exception exc) {
        LogUtil.printException(log_, msg, exc);
    }

    public static void main(String[] args) {
        new Server();
    }
}

