/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.collab;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ucar.unidata.collab.SharableImpl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;

public abstract class PropertiedThing
extends SharableImpl
implements PropertyChangeListener {
    private volatile PropertyChangeSupport propertyListeners;
    protected JDialog propertiesDialog;

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        if (this.propertyListeners != null) {
            this.propertyListeners.firePropertyChange(event);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners != null) {
            this.propertyListeners.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyChangeSupport getPropertyListeners() {
        if (this.propertyListeners == null) {
            PropertiedThing propertiedThing = this;
            synchronized (propertiedThing) {
                if (this.propertyListeners == null) {
                    this.propertyListeners = new PropertyChangeSupport(this);
                }
            }
        }
        return this.propertyListeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyListeners().addPropertyChangeListener(listener);
    }

    protected void getPropertiesComponents(List comps, int tabIdx) {
    }

    public String[] getPropertyTabs() {
        return new String[]{""};
    }

    public boolean showProperties() {
        return this.showProperties(null, 0, 0);
    }

    public boolean showProperties(JComponent where, int x, int y) {
        if (this.isShowing()) {
            return false;
        }
        try {
            JComponent contents;
            String[] tabs = this.getPropertyTabs();
            if (tabs.length <= 1) {
                ArrayList comps = new ArrayList();
                this.getPropertiesComponents(comps, 0);
                GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
                contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            } else {
                JTabbedPane tabbedPane = new JTabbedPane();
                for (int tabIdx = 0; tabIdx < tabs.length; ++tabIdx) {
                    ArrayList comps = new ArrayList();
                    this.getPropertiesComponents(comps, tabIdx);
                    GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
                    JPanel comp = GuiUtils.top(GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N));
                    tabbedPane.add(tabs[tabIdx], GuiUtils.inset((Component)comp, 5));
                }
                contents = tabbedPane;
            }
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String cmd = ae.getActionCommand();
                    if ((cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) && !PropertiedThing.this.doApplyProperties()) {
                        return;
                    }
                    if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                        PropertiedThing.this.propertiesDialog.dispose();
                        PropertiedThing.this.propertiesDialog = null;
                    }
                }
            };
            JPanel buttons = GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_APPLY, GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL});
            contents = GuiUtils.centerBottom(contents, buttons);
            contents = GuiUtils.inset((Component)contents, 5);
            this.propertiesDialog = GuiUtils.createDialog("Properties: " + this.toString(), true);
            this.propertiesDialog.getContentPane().add(GuiUtils.top(contents));
            this.propertiesDialog.pack();
            if (where != null) {
                Point loc = where.getLocationOnScreen();
                loc.x += x;
                loc.y += y;
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                screenSize.height -= 50;
                Dimension windowSize = this.propertiesDialog.getSize();
                if (loc.y + windowSize.height > screenSize.height) {
                    loc.y = screenSize.height - windowSize.height;
                }
                if (loc.x + windowSize.width > screenSize.width) {
                    loc.x = screenSize.width - windowSize.width;
                }
                this.propertiesDialog.setLocation(loc);
            }
            this.propertiesDialog.setVisible(true);
            this.propertiesDialog = null;
            return true;
        }
        catch (Exception exc) {
            LogUtil.logException("Creating properties dialog", exc);
            return false;
        }
    }

    public boolean isShowing() {
        return this.propertiesDialog != null;
    }

    protected boolean applyProperties() {
        return true;
    }

    protected boolean doApplyProperties() {
        return this.applyProperties();
    }
}

