/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.collab;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import ucar.unidata.collab.Server;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class Client {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(Client.class.getName());
    private boolean isListening = false;
    private String hostname;
    private int port = Server.DEFAULT_PORT;
    private Socket socket;
    private InputStream input;
    private Writer output;
    private boolean okToSend = true;
    private boolean okToReceive = true;
    private boolean valid = false;
    byte[] mainBuffer = new byte[1000000];
    String msgBuffer = "";
    int numCharsNeeded = 0;

    public Client() {
    }

    public Client(String host) {
        this(host, -1);
    }

    public Client(String host, int thePort) {
        this.hostname = host;
        List<String> l = StringUtil.split(this.hostname, ":");
        if (l.size() > 1) {
            this.hostname = l.get(0);
            this.port = new Integer(l.get(1));
        } else {
            this.port = thePort;
        }
        try {
            this.socket = new Socket(this.hostname, this.port);
            this.debug("Connected with server " + this.socket.getInetAddress() + ":" + this.socket.getPort());
            this.output = new PrintWriter(this.socket.getOutputStream(), true);
            this.input = this.socket.getInputStream();
        }
        catch (UnknownHostException uhe) {
            this.socket = null;
            this.output = null;
            this.input = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Client(Socket socket) throws IOException {
        this.socket = socket;
        this.hostname = socket.getInetAddress() + ":" + socket.getPort();
        this.output = new PrintWriter(socket.getOutputStream(), true);
        this.input = socket.getInputStream();
    }

    public void debug(String msg) {
        System.err.println(msg);
    }

    private void initListening() {
        if (this.isListening) {
            return;
        }
        Misc.run(new Runnable(){

            @Override
            public void run() {
                Client.this.runClient();
            }
        });
    }

    private void runClient() {
        this.isListening = true;
        while (this.isConnectionOk()) {
            try {
                String message = this.read();
                if (message == null) break;
                if (!this.okToReceive) continue;
                this.handleServerMessage(message);
            }
            catch (IOException e) {
                this.debug("Client got error in runServer");
                break;
            }
        }
        this.isListening = false;
        this.close();
    }

    public boolean isConnectionOk() {
        return this.output != null;
    }

    protected void handleServerMessage(String message) {
    }

    protected String read() throws IOException {
        String errorMsg = null;
        while (this.isConnectionOk()) {
            int idx;
            if (this.numCharsNeeded == 0 && (idx = this.msgBuffer.indexOf(";")) > 0) {
                this.numCharsNeeded = Integer.decode(this.msgBuffer.substring(0, idx));
                this.msgBuffer = this.msgBuffer.substring(idx + 1);
            }
            if (this.numCharsNeeded == 0 || this.numCharsNeeded > this.msgBuffer.length()) {
                int bytesRead = this.input.read(this.mainBuffer, 0, this.mainBuffer.length);
                if (!this.isConnectionOk()) break;
                if (bytesRead == 0) continue;
                if (bytesRead == -1) {
                    errorMsg = "Read -1 bytes.  Connection to the server has been lost";
                    break;
                }
                this.msgBuffer = this.msgBuffer + new String(this.mainBuffer, 0, bytesRead);
            }
            if (this.numCharsNeeded == 0) {
                idx = this.msgBuffer.indexOf(";");
                if (idx < 0) continue;
                this.numCharsNeeded = Integer.decode(this.msgBuffer.substring(0, idx));
                this.msgBuffer = this.msgBuffer.substring(idx + 1);
            }
            if (this.numCharsNeeded > this.msgBuffer.length()) continue;
            String msg = this.msgBuffer.substring(0, this.numCharsNeeded);
            this.msgBuffer = this.msgBuffer.substring(this.numCharsNeeded);
            this.numCharsNeeded = 0;
            return msg;
        }
        return null;
    }

    public void close() {
        try {
            this.input = null;
            this.output = null;
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(String message) {
        try {
            if (!this.okToSend) {
                return;
            }
            int length = message.length();
            this.output.write(length + ";");
            this.output.write(message);
            this.output.flush();
        }
        catch (Exception ioe) {
            this.logException("Writing message:" + message, ioe);
        }
    }

    protected void logException(String msg, Exception exc) {
        LogUtil.printException(log_, msg, exc);
    }

    public String toString() {
        return this.hostname;
    }

    public void setHostname(String value) {
        this.hostname = value;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    public boolean getValid() {
        return this.valid;
    }

    public void setOkToSend(boolean value) {
        this.okToSend = value;
    }

    public boolean getOkToSend() {
        return this.okToSend;
    }

    public void setOkToReceive(boolean value) {
        this.okToReceive = value;
    }

    public boolean getOkToReceive() {
        return this.okToReceive;
    }

    public static void main(String[] args) {
        try {
            Client client = new Client(args[0]);
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (client.isConnectionOk()) {
                String lineToBeSent = input.readLine();
                if (!client.isConnectionOk()) {
                    System.err.println("Connection closed");
                    System.exit(0);
                }
                client.write(lineToBeSent);
            }
        }
        catch (Exception exc) {
            System.err.println("Error:" + exc);
        }
    }
}

