/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.beans;

import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import ucar.unidata.beans.AbstractProperty;

public class VetoableProperty
extends AbstractProperty {
    private VetoableChangeSupport listeners;

    public VetoableProperty(Object sourceBean, String name) {
        super(sourceBean, name);
    }

    @Override
    public boolean isVetoable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this.listeners == null) {
            VetoableProperty vetoableProperty = this;
            synchronized (vetoableProperty) {
                if (this.listeners == null) {
                    this.listeners = new VetoableChangeSupport(this.getSourceBean());
                }
            }
        }
        this.listeners.addVetoableChangeListener(this.getName(), listener);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removeVetoableChangeListener(this.getName(), listener);
        }
    }

    @Override
    public void setValueAndNotifyListeners(Object newValue) throws PropertyVetoException {
        this.setValue(newValue);
        this.notifyListeners();
    }

    @Override
    public void setValue(Object newValue) throws PropertyVetoException {
        Object oldValue;
        if (!(this.listeners == null || (oldValue = this.getValue()) != null && newValue != null && oldValue.equals(newValue))) {
            this.listeners.fireVetoableChange(this.getName(), this.getValue(), newValue);
        }
        this.setCurrentValue(newValue);
    }
}

