/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.beans;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import ucar.unidata.beans.Property;

public class PropertySet
implements Serializable {
    private final Map propertyNameMap = new TreeMap();

    public void addProperty(Property property) {
        this.propertyNameMap.put(property.getName(), property);
    }

    public void removeProperty(Property property) {
        this.propertyNameMap.remove(property.getName());
    }

    public Property getProperty(String name) {
        return (Property)this.propertyNameMap.get(name);
    }

    public synchronized void disablePropertyChangeEvents() {
        Iterator iter = this.propertyNameMap.values().iterator();
        while (iter.hasNext()) {
            ((Property)iter.next()).setReporting(false);
        }
    }

    public synchronized void enablePropertyChangeEvents() {
        for (Property property : this.propertyNameMap.values()) {
            property.setReporting(true);
            property.notifyListeners();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Iterator iter = this.propertyNameMap.values().iterator();
        while (iter.hasNext()) {
            ((Property)iter.next()).addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Iterator iter = this.propertyNameMap.values().iterator();
        while (iter.hasNext()) {
            ((Property)iter.next()).removePropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        Property property = (Property)this.propertyNameMap.get(name);
        if (property != null) {
            property.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        Property property = (Property)this.propertyNameMap.get(name);
        if (property != null) {
            property.removePropertyChangeListener(listener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        Iterator iter = this.propertyNameMap.values().iterator();
        while (iter.hasNext()) {
            ((Property)iter.next()).addVetoableChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        Iterator iter = this.propertyNameMap.values().iterator();
        while (iter.hasNext()) {
            ((Property)iter.next()).removeVetoableChangeListener(listener);
        }
    }

    public void addVetoableChangeListener(String name, VetoableChangeListener listener) {
        Property property = (Property)this.propertyNameMap.get(name);
        if (property != null) {
            property.addVetoableChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener listener) {
        Property property = (Property)this.propertyNameMap.get(name);
        if (property != null) {
            property.removeVetoableChangeListener(listener);
        }
    }
}

