/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import ucar.unidata.beans.Property;

public abstract class AbstractProperty
implements Property {
    private PropertyChangeSupport listeners;
    private final Object sourceBean;
    private boolean reportChanges = true;
    private Object previousValue;
    private Object currentValue;
    private final String name;

    protected AbstractProperty(Object sourceBean, String name) {
        this.sourceBean = sourceBean;
        this.name = name;
        this.previousValue = null;
        this.currentValue = null;
    }

    @Override
    public final Object getSourceBean() {
        return this.sourceBean;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            AbstractProperty abstractProperty = this;
            synchronized (abstractProperty) {
                if (this.listeners == null) {
                    this.listeners = new PropertyChangeSupport(this.sourceBean);
                }
            }
        }
        this.listeners.addPropertyChangeListener(this.name, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(this.name, listener);
        }
    }

    @Override
    public abstract void addVetoableChangeListener(VetoableChangeListener var1) throws UnsupportedOperationException;

    @Override
    public abstract void removeVetoableChangeListener(VetoableChangeListener var1);

    @Override
    public abstract boolean isVetoable();

    @Override
    public abstract void setValueAndNotifyListeners(Object var1) throws PropertyVetoException;

    @Override
    public abstract void setValue(Object var1) throws PropertyVetoException;

    protected final void setCurrentValue(Object newValue) {
        this.currentValue = newValue;
    }

    @Override
    public final void setReporting(boolean reportChanges) {
        this.reportChanges = reportChanges;
    }

    @Override
    public final boolean isReporting() {
        return this.reportChanges;
    }

    @Override
    public final void notifyListeners() {
        if (this.reportChanges && this.listeners != null && (this.previousValue == null || this.currentValue == null || !this.currentValue.equals(this.previousValue))) {
            Object oldValue = this.previousValue;
            this.previousValue = this.currentValue;
            this.listeners.firePropertyChange(this.name, oldValue, this.currentValue);
        }
    }

    @Override
    public void clearValue() {
        this.previousValue = null;
        this.currentValue = null;
    }
}

